% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_delete_app_input_source}
\alias{resiliencehub_delete_app_input_source}
\title{Deletes the input source and all of its imported resources from the
Resilience Hub application}
\usage{
resiliencehub_delete_app_input_source(
  appArn,
  clientToken = NULL,
  eksSourceClusterNamespace = NULL,
  sourceArn = NULL,
  terraformSource = NULL
)
}
\arguments{
\item{appArn}{[required] The Amazon Resource Name (ARN) of the Resilience Hub application. The
format for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{eksSourceClusterNamespace}{The namespace on your Amazon Elastic Kubernetes Service cluster that you
want to delete from the Resilience Hub application.}

\item{sourceArn}{The Amazon Resource Name (ARN) of the imported resource you want to
remove from the Resilience Hub application. For more information about
ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{terraformSource}{The imported Terraform s3 state ﬁle you want to remove from the
Resilience Hub application.}
}
\description{
Deletes the input source and all of its imported resources from the Resilience Hub application.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_delete_app_input_source/} for full documentation.
}
\keyword{internal}
