# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ssmincidents_service.R
NULL

#' A replication set replicates and encrypts your data to the provided
#' Regions with the provided KMS key
#'
#' @description
#' A replication set replicates and encrypts your data to the provided Regions with the provided KMS key.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_create_replication_set/](https://www.paws-r-sdk.com/docs/ssmincidents_create_replication_set/) for full documentation.
#'
#' @param clientToken A token that ensures that the operation is called only once with the
#' specified details.
#' @param regions &#91;required&#93; The Regions that Incident Manager replicates your data to. You can have
#' up to three Regions in your replication set.
#' @param tags A list of tags to add to the replication set.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_create_replication_set
ssmincidents_create_replication_set <- function(clientToken = NULL, regions, tags = NULL) {
  op <- new_operation(
    name = "CreateReplicationSet",
    http_method = "POST",
    http_path = "/createReplicationSet",
    paginator = list()
  )
  input <- .ssmincidents$create_replication_set_input(clientToken = clientToken, regions = regions, tags = tags)
  output <- .ssmincidents$create_replication_set_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$create_replication_set <- ssmincidents_create_replication_set

#' Creates a response plan that automates the initial response to incidents
#'
#' @description
#' Creates a response plan that automates the initial response to incidents. A response plan engages contacts, starts chat channel collaboration, and initiates runbooks at the beginning of an incident.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_create_response_plan/](https://www.paws-r-sdk.com/docs/ssmincidents_create_response_plan/) for full documentation.
#'
#' @param actions The actions that the response plan starts at the beginning of an
#' incident.
#' @param chatChannel The Chatbot chat channel used for collaboration during an incident.
#' @param clientToken A token ensuring that the operation is called only once with the
#' specified details.
#' @param displayName The long format of the response plan name. This field can contain
#' spaces.
#' @param engagements The Amazon Resource Name (ARN) for the contacts and escalation plans
#' that the response plan engages during an incident.
#' @param incidentTemplate &#91;required&#93; Details used to create an incident when using this response plan.
#' @param integrations Information about third-party services integrated into the response
#' plan.
#' @param name &#91;required&#93; The short format name of the response plan. Can't include spaces.
#' @param tags A list of tags that you are adding to the response plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_create_response_plan
ssmincidents_create_response_plan <- function(actions = NULL, chatChannel = NULL, clientToken = NULL, displayName = NULL, engagements = NULL, incidentTemplate, integrations = NULL, name, tags = NULL) {
  op <- new_operation(
    name = "CreateResponsePlan",
    http_method = "POST",
    http_path = "/createResponsePlan",
    paginator = list()
  )
  input <- .ssmincidents$create_response_plan_input(actions = actions, chatChannel = chatChannel, clientToken = clientToken, displayName = displayName, engagements = engagements, incidentTemplate = incidentTemplate, integrations = integrations, name = name, tags = tags)
  output <- .ssmincidents$create_response_plan_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$create_response_plan <- ssmincidents_create_response_plan

#' Creates a custom timeline event on the incident details page of an
#' incident record
#'
#' @description
#' Creates a custom timeline event on the incident details page of an incident record. Incident Manager automatically creates timeline events that mark key moments during an incident. You can create custom timeline events to mark important events that Incident Manager can detect automatically.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_create_timeline_event/](https://www.paws-r-sdk.com/docs/ssmincidents_create_timeline_event/) for full documentation.
#'
#' @param clientToken A token that ensures that a client calls the action only once with the
#' specified details.
#' @param eventData &#91;required&#93; A short description of the event.
#' @param eventReferences Adds one or more references to the `TimelineEvent`. A reference is an
#' Amazon Web Services resource involved or associated with the incident.
#' To specify a reference, enter its Amazon Resource Name (ARN). You can
#' also specify a related item associated with a resource. For example, to
#' specify an Amazon DynamoDB (DynamoDB) table as a resource, use the
#' table's ARN. You can also specify an Amazon CloudWatch metric associated
#' with the DynamoDB table as a related item.
#' @param eventTime &#91;required&#93; The time that the event occurred.
#' @param eventType &#91;required&#93; The type of event. You can create timeline events of type
#' `Custom Event`.
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident record that the action
#' adds the incident to.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_create_timeline_event
ssmincidents_create_timeline_event <- function(clientToken = NULL, eventData, eventReferences = NULL, eventTime, eventType, incidentRecordArn) {
  op <- new_operation(
    name = "CreateTimelineEvent",
    http_method = "POST",
    http_path = "/createTimelineEvent",
    paginator = list()
  )
  input <- .ssmincidents$create_timeline_event_input(clientToken = clientToken, eventData = eventData, eventReferences = eventReferences, eventTime = eventTime, eventType = eventType, incidentRecordArn = incidentRecordArn)
  output <- .ssmincidents$create_timeline_event_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$create_timeline_event <- ssmincidents_create_timeline_event

#' Delete an incident record from Incident Manager
#'
#' @description
#' Delete an incident record from Incident Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_delete_incident_record/](https://www.paws-r-sdk.com/docs/ssmincidents_delete_incident_record/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the incident record you are deleting.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_delete_incident_record
ssmincidents_delete_incident_record <- function(arn) {
  op <- new_operation(
    name = "DeleteIncidentRecord",
    http_method = "POST",
    http_path = "/deleteIncidentRecord",
    paginator = list()
  )
  input <- .ssmincidents$delete_incident_record_input(arn = arn)
  output <- .ssmincidents$delete_incident_record_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$delete_incident_record <- ssmincidents_delete_incident_record

#' Deletes all Regions in your replication set
#'
#' @description
#' Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_delete_replication_set/](https://www.paws-r-sdk.com/docs/ssmincidents_delete_replication_set/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the replication set you're deleting.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_delete_replication_set
ssmincidents_delete_replication_set <- function(arn) {
  op <- new_operation(
    name = "DeleteReplicationSet",
    http_method = "POST",
    http_path = "/deleteReplicationSet",
    paginator = list()
  )
  input <- .ssmincidents$delete_replication_set_input(arn = arn)
  output <- .ssmincidents$delete_replication_set_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$delete_replication_set <- ssmincidents_delete_replication_set

#' Deletes the resource policy that Resource Access Manager uses to share
#' your Incident Manager resource
#'
#' @description
#' Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_delete_resource_policy/](https://www.paws-r-sdk.com/docs/ssmincidents_delete_resource_policy/) for full documentation.
#'
#' @param policyId &#91;required&#93; The ID of the resource policy you're deleting.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you're deleting the
#' policy from.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_delete_resource_policy
ssmincidents_delete_resource_policy <- function(policyId, resourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/deleteResourcePolicy",
    paginator = list()
  )
  input <- .ssmincidents$delete_resource_policy_input(policyId = policyId, resourceArn = resourceArn)
  output <- .ssmincidents$delete_resource_policy_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$delete_resource_policy <- ssmincidents_delete_resource_policy

#' Deletes the specified response plan
#'
#' @description
#' Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge events from creating an incident with this response plan.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_delete_response_plan/](https://www.paws-r-sdk.com/docs/ssmincidents_delete_response_plan/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_delete_response_plan
ssmincidents_delete_response_plan <- function(arn) {
  op <- new_operation(
    name = "DeleteResponsePlan",
    http_method = "POST",
    http_path = "/deleteResponsePlan",
    paginator = list()
  )
  input <- .ssmincidents$delete_response_plan_input(arn = arn)
  output <- .ssmincidents$delete_response_plan_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$delete_response_plan <- ssmincidents_delete_response_plan

#' Deletes a timeline event from an incident
#'
#' @description
#' Deletes a timeline event from an incident.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_delete_timeline_event/](https://www.paws-r-sdk.com/docs/ssmincidents_delete_timeline_event/) for full documentation.
#'
#' @param eventId &#91;required&#93; The ID of the event to update. You can use
#' [`list_timeline_events`][ssmincidents_list_timeline_events] to find an
#' event's ID.
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident that includes the
#' timeline event.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_delete_timeline_event
ssmincidents_delete_timeline_event <- function(eventId, incidentRecordArn) {
  op <- new_operation(
    name = "DeleteTimelineEvent",
    http_method = "POST",
    http_path = "/deleteTimelineEvent",
    paginator = list()
  )
  input <- .ssmincidents$delete_timeline_event_input(eventId = eventId, incidentRecordArn = incidentRecordArn)
  output <- .ssmincidents$delete_timeline_event_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$delete_timeline_event <- ssmincidents_delete_timeline_event

#' Returns the details for the specified incident record
#'
#' @description
#' Returns the details for the specified incident record.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_get_incident_record/](https://www.paws-r-sdk.com/docs/ssmincidents_get_incident_record/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the incident record.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_get_incident_record
ssmincidents_get_incident_record <- function(arn) {
  op <- new_operation(
    name = "GetIncidentRecord",
    http_method = "GET",
    http_path = "/getIncidentRecord",
    paginator = list()
  )
  input <- .ssmincidents$get_incident_record_input(arn = arn)
  output <- .ssmincidents$get_incident_record_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$get_incident_record <- ssmincidents_get_incident_record

#' Retrieve your Incident Manager replication set
#'
#' @description
#' Retrieve your Incident Manager replication set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_get_replication_set/](https://www.paws-r-sdk.com/docs/ssmincidents_get_replication_set/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the replication set you want to
#' retrieve.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_get_replication_set
ssmincidents_get_replication_set <- function(arn) {
  op <- new_operation(
    name = "GetReplicationSet",
    http_method = "GET",
    http_path = "/getReplicationSet",
    paginator = list()
  )
  input <- .ssmincidents$get_replication_set_input(arn = arn)
  output <- .ssmincidents$get_replication_set_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$get_replication_set <- ssmincidents_get_replication_set

#' Retrieves the resource policies attached to the specified response plan
#'
#' @description
#' Retrieves the resource policies attached to the specified response plan.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_get_resource_policies/](https://www.paws-r-sdk.com/docs/ssmincidents_get_resource_policies/) for full documentation.
#'
#' @param maxResults The maximum number of resource policies to display for each page of
#' results.
#' @param nextToken The pagination token to continue to the next page of results.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan with the attached
#' resource policy.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_get_resource_policies
ssmincidents_get_resource_policies <- function(maxResults = NULL, nextToken = NULL, resourceArn) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/getResourcePolicies",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "resourcePolicies")
  )
  input <- .ssmincidents$get_resource_policies_input(maxResults = maxResults, nextToken = nextToken, resourceArn = resourceArn)
  output <- .ssmincidents$get_resource_policies_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$get_resource_policies <- ssmincidents_get_resource_policies

#' Retrieves the details of the specified response plan
#'
#' @description
#' Retrieves the details of the specified response plan.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_get_response_plan/](https://www.paws-r-sdk.com/docs/ssmincidents_get_response_plan/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_get_response_plan
ssmincidents_get_response_plan <- function(arn) {
  op <- new_operation(
    name = "GetResponsePlan",
    http_method = "GET",
    http_path = "/getResponsePlan",
    paginator = list()
  )
  input <- .ssmincidents$get_response_plan_input(arn = arn)
  output <- .ssmincidents$get_response_plan_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$get_response_plan <- ssmincidents_get_response_plan

#' Retrieves a timeline event based on its ID and incident record
#'
#' @description
#' Retrieves a timeline event based on its ID and incident record.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_get_timeline_event/](https://www.paws-r-sdk.com/docs/ssmincidents_get_timeline_event/) for full documentation.
#'
#' @param eventId &#91;required&#93; The ID of the event. You can get an event's ID when you create it, or by
#' using [`list_timeline_events`][ssmincidents_list_timeline_events].
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident that includes the
#' timeline event.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_get_timeline_event
ssmincidents_get_timeline_event <- function(eventId, incidentRecordArn) {
  op <- new_operation(
    name = "GetTimelineEvent",
    http_method = "GET",
    http_path = "/getTimelineEvent",
    paginator = list()
  )
  input <- .ssmincidents$get_timeline_event_input(eventId = eventId, incidentRecordArn = incidentRecordArn)
  output <- .ssmincidents$get_timeline_event_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$get_timeline_event <- ssmincidents_get_timeline_event

#' Lists all incident records in your account
#'
#' @description
#' Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the incident record you want to update.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_list_incident_records/](https://www.paws-r-sdk.com/docs/ssmincidents_list_incident_records/) for full documentation.
#'
#' @param filters Filters the list of incident records you want to search through. You can
#' filter on the following keys:
#' 
#' -   `creationTime`
#' 
#' -   `impact`
#' 
#' -   `status`
#' 
#' -   `createdBy`
#' 
#' Note the following when when you use Filters:
#' 
#' -   If you don't specify a Filter, the response includes all incident
#'     records.
#' 
#' -   If you specify more than one filter in a single request, the
#'     response returns incident records that match all filters.
#' 
#' -   If you specify a filter with more than one value, the response
#'     returns incident records that match any of the values provided.
#' @param maxResults The maximum number of results per page.
#' @param nextToken The pagination token to continue to the next page of results.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_list_incident_records
ssmincidents_list_incident_records <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIncidentRecords",
    http_method = "POST",
    http_path = "/listIncidentRecords",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "incidentRecordSummaries")
  )
  input <- .ssmincidents$list_incident_records_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .ssmincidents$list_incident_records_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$list_incident_records <- ssmincidents_list_incident_records

#' List all related items for an incident record
#'
#' @description
#' List all related items for an incident record.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_list_related_items/](https://www.paws-r-sdk.com/docs/ssmincidents_list_related_items/) for full documentation.
#'
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident record containing the
#' listed related items.
#' @param maxResults The maximum number of related items per page.
#' @param nextToken The pagination token to continue to the next page of results.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_list_related_items
ssmincidents_list_related_items <- function(incidentRecordArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRelatedItems",
    http_method = "POST",
    http_path = "/listRelatedItems",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "relatedItems")
  )
  input <- .ssmincidents$list_related_items_input(incidentRecordArn = incidentRecordArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ssmincidents$list_related_items_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$list_related_items <- ssmincidents_list_related_items

#' Lists details about the replication set configured in your account
#'
#' @description
#' Lists details about the replication set configured in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_list_replication_sets/](https://www.paws-r-sdk.com/docs/ssmincidents_list_replication_sets/) for full documentation.
#'
#' @param maxResults The maximum number of results per page.
#' @param nextToken The pagination token to continue to the next page of results.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_list_replication_sets
ssmincidents_list_replication_sets <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListReplicationSets",
    http_method = "POST",
    http_path = "/listReplicationSets",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "replicationSetArns")
  )
  input <- .ssmincidents$list_replication_sets_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ssmincidents$list_replication_sets_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$list_replication_sets <- ssmincidents_list_replication_sets

#' Lists all response plans in your account
#'
#' @description
#' Lists all response plans in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_list_response_plans/](https://www.paws-r-sdk.com/docs/ssmincidents_list_response_plans/) for full documentation.
#'
#' @param maxResults The maximum number of response plans per page.
#' @param nextToken The pagination token to continue to the next page of results.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_list_response_plans
ssmincidents_list_response_plans <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListResponsePlans",
    http_method = "POST",
    http_path = "/listResponsePlans",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "responsePlanSummaries")
  )
  input <- .ssmincidents$list_response_plans_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ssmincidents$list_response_plans_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$list_response_plans <- ssmincidents_list_response_plans

#' Lists the tags that are attached to the specified response plan
#'
#' @description
#' Lists the tags that are attached to the specified response plan.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ssmincidents_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_list_tags_for_resource
ssmincidents_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ssmincidents$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ssmincidents$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$list_tags_for_resource <- ssmincidents_list_tags_for_resource

#' Lists timeline events for the specified incident record
#'
#' @description
#' Lists timeline events for the specified incident record.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_list_timeline_events/](https://www.paws-r-sdk.com/docs/ssmincidents_list_timeline_events/) for full documentation.
#'
#' @param filters Filters the timeline events based on the provided conditional values.
#' You can filter timeline events with the following keys:
#' 
#' -   `eventTime`
#' 
#' -   `eventType`
#' 
#' Note the following when deciding how to use Filters:
#' 
#' -   If you don't specify a Filter, the response includes all timeline
#'     events.
#' 
#' -   If you specify more than one filter in a single request, the
#'     response returns timeline events that match all filters.
#' 
#' -   If you specify a filter with more than one value, the response
#'     returns timeline events that match any of the values provided.
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident that includes the
#' timeline event.
#' @param maxResults The maximum number of results per page.
#' @param nextToken The pagination token to continue to the next page of results.
#' @param sortBy Sort timeline events by the specified key value pair.
#' @param sortOrder Sorts the order of timeline events by the value specified in the
#' `sortBy` field.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_list_timeline_events
ssmincidents_list_timeline_events <- function(filters = NULL, incidentRecordArn, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListTimelineEvents",
    http_method = "POST",
    http_path = "/listTimelineEvents",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "eventSummaries")
  )
  input <- .ssmincidents$list_timeline_events_input(filters = filters, incidentRecordArn = incidentRecordArn, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .ssmincidents$list_timeline_events_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$list_timeline_events <- ssmincidents_list_timeline_events

#' Adds a resource policy to the specified response plan
#'
#' @description
#' Adds a resource policy to the specified response plan. The resource policy is used to share the response plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Cross-Region and cross-account incident management](https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-cross-account-cross-region.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_put_resource_policy/](https://www.paws-r-sdk.com/docs/ssmincidents_put_resource_policy/) for full documentation.
#'
#' @param policy &#91;required&#93; Details of the resource policy.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan to add the resource
#' policy to.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_put_resource_policy
ssmincidents_put_resource_policy <- function(policy, resourceArn) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/putResourcePolicy",
    paginator = list()
  )
  input <- .ssmincidents$put_resource_policy_input(policy = policy, resourceArn = resourceArn)
  output <- .ssmincidents$put_resource_policy_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$put_resource_policy <- ssmincidents_put_resource_policy

#' Used to start an incident from CloudWatch alarms, EventBridge events, or
#' manually
#'
#' @description
#' Used to start an incident from CloudWatch alarms, EventBridge events, or manually.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_start_incident/](https://www.paws-r-sdk.com/docs/ssmincidents_start_incident/) for full documentation.
#'
#' @param clientToken A token ensuring that the operation is called only once with the
#' specified details.
#' @param impact Defines the impact to the customers. Providing an impact overwrites the
#' impact provided by a response plan.
#' 
#' **Possible impacts:**
#' 
#' -   `1` - Critical impact, this typically relates to full application
#'     failure that impacts many to all customers.
#' 
#' -   `2` - High impact, partial application failure with impact to many
#'     customers.
#' 
#' -   `3` - Medium impact, the application is providing reduced service to
#'     customers.
#' 
#' -   `4` - Low impact, customer might aren't impacted by the problem yet.
#' 
#' -   `5` - No impact, customers aren't currently impacted but urgent
#'     action is needed to avoid impact.
#' @param relatedItems Add related items to the incident for other responders to use. Related
#' items are Amazon Web Services resources, external links, or files
#' uploaded to an Amazon S3 bucket.
#' @param responsePlanArn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan that pre-defines
#' summary, chat channels, Amazon SNS topics, runbooks, title, and impact
#' of the incident.
#' @param title Provide a title for the incident. Providing a title overwrites the title
#' provided by the response plan.
#' @param triggerDetails Details of what created the incident record in Incident Manager.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_start_incident
ssmincidents_start_incident <- function(clientToken = NULL, impact = NULL, relatedItems = NULL, responsePlanArn, title = NULL, triggerDetails = NULL) {
  op <- new_operation(
    name = "StartIncident",
    http_method = "POST",
    http_path = "/startIncident",
    paginator = list()
  )
  input <- .ssmincidents$start_incident_input(clientToken = clientToken, impact = impact, relatedItems = relatedItems, responsePlanArn = responsePlanArn, title = title, triggerDetails = triggerDetails)
  output <- .ssmincidents$start_incident_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$start_incident <- ssmincidents_start_incident

#' Adds a tag to a response plan
#'
#' @description
#' Adds a tag to a response plan.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_tag_resource/](https://www.paws-r-sdk.com/docs/ssmincidents_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan you're adding the
#' tags to.
#' @param tags &#91;required&#93; A list of tags to add to the response plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_tag_resource
ssmincidents_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ssmincidents$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ssmincidents$tag_resource_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$tag_resource <- ssmincidents_tag_resource

#' Removes a tag from a resource
#'
#' @description
#' Removes a tag from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_untag_resource/](https://www.paws-r-sdk.com/docs/ssmincidents_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan you're removing a
#' tag from.
#' @param tagKeys &#91;required&#93; The name of the tag to remove from the response plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_untag_resource
ssmincidents_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ssmincidents$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ssmincidents$untag_resource_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$untag_resource <- ssmincidents_untag_resource

#' Update deletion protection to either allow or deny deletion of the final
#' Region in a replication set
#'
#' @description
#' Update deletion protection to either allow or deny deletion of the final Region in a replication set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_update_deletion_protection/](https://www.paws-r-sdk.com/docs/ssmincidents_update_deletion_protection/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the replication set to update.
#' @param clientToken A token that ensures that the operation is called only once with the
#' specified details.
#' @param deletionProtected &#91;required&#93; Specifies if deletion protection is turned on or off in your account.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_update_deletion_protection
ssmincidents_update_deletion_protection <- function(arn, clientToken = NULL, deletionProtected) {
  op <- new_operation(
    name = "UpdateDeletionProtection",
    http_method = "POST",
    http_path = "/updateDeletionProtection",
    paginator = list()
  )
  input <- .ssmincidents$update_deletion_protection_input(arn = arn, clientToken = clientToken, deletionProtected = deletionProtected)
  output <- .ssmincidents$update_deletion_protection_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$update_deletion_protection <- ssmincidents_update_deletion_protection

#' Update the details of an incident record
#'
#' @description
#' Update the details of an incident record. You can use this operation to update an incident record from the defined chat channel. For more information about using actions in chat channels, see [Interacting through chat](https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact).
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_update_incident_record/](https://www.paws-r-sdk.com/docs/ssmincidents_update_incident_record/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the incident record you are updating.
#' @param chatChannel The Chatbot chat channel where responders can collaborate.
#' @param clientToken A token that ensures that a client calls the operation only once with
#' the specified details.
#' @param impact Defines the impact of the incident to customers and applications. If you
#' provide an impact for an incident, it overwrites the impact provided by
#' the response plan.
#' 
#' **Possible impacts:**
#' 
#' -   `1` - Critical impact, full application failure that impacts many to
#'     all customers.
#' 
#' -   `2` - High impact, partial application failure with impact to many
#'     customers.
#' 
#' -   `3` - Medium impact, the application is providing reduced service to
#'     customers.
#' 
#' -   `4` - Low impact, customer aren't impacted by the problem yet.
#' 
#' -   `5` - No impact, customers aren't currently impacted but urgent
#'     action is needed to avoid impact.
#' @param notificationTargets The Amazon SNS targets that Incident Manager notifies when a client
#' updates an incident.
#' 
#' Using multiple SNS topics creates redundancy in the event that a Region
#' is down during the incident.
#' @param status The status of the incident. Possible statuses are `Open` or `Resolved`.
#' @param summary A longer description of what occurred during the incident.
#' @param title A brief description of the incident.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_update_incident_record
ssmincidents_update_incident_record <- function(arn, chatChannel = NULL, clientToken = NULL, impact = NULL, notificationTargets = NULL, status = NULL, summary = NULL, title = NULL) {
  op <- new_operation(
    name = "UpdateIncidentRecord",
    http_method = "POST",
    http_path = "/updateIncidentRecord",
    paginator = list()
  )
  input <- .ssmincidents$update_incident_record_input(arn = arn, chatChannel = chatChannel, clientToken = clientToken, impact = impact, notificationTargets = notificationTargets, status = status, summary = summary, title = title)
  output <- .ssmincidents$update_incident_record_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$update_incident_record <- ssmincidents_update_incident_record

#' Add or remove related items from the related items tab of an incident
#' record
#'
#' @description
#' Add or remove related items from the related items tab of an incident record.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_update_related_items/](https://www.paws-r-sdk.com/docs/ssmincidents_update_related_items/) for full documentation.
#'
#' @param clientToken A token that ensures that a client calls the operation only once with
#' the specified details.
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident record that contains the
#' related items that you update.
#' @param relatedItemsUpdate &#91;required&#93; Details about the item that you are add to, or delete from, an incident.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_update_related_items
ssmincidents_update_related_items <- function(clientToken = NULL, incidentRecordArn, relatedItemsUpdate) {
  op <- new_operation(
    name = "UpdateRelatedItems",
    http_method = "POST",
    http_path = "/updateRelatedItems",
    paginator = list()
  )
  input <- .ssmincidents$update_related_items_input(clientToken = clientToken, incidentRecordArn = incidentRecordArn, relatedItemsUpdate = relatedItemsUpdate)
  output <- .ssmincidents$update_related_items_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$update_related_items <- ssmincidents_update_related_items

#' Add or delete Regions from your replication set
#'
#' @description
#' Add or delete Regions from your replication set.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_update_replication_set/](https://www.paws-r-sdk.com/docs/ssmincidents_update_replication_set/) for full documentation.
#'
#' @param actions &#91;required&#93; An action to add or delete a Region.
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the replication set you're updating.
#' @param clientToken A token that ensures that the operation is called only once with the
#' specified details.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_update_replication_set
ssmincidents_update_replication_set <- function(actions, arn, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateReplicationSet",
    http_method = "POST",
    http_path = "/updateReplicationSet",
    paginator = list()
  )
  input <- .ssmincidents$update_replication_set_input(actions = actions, arn = arn, clientToken = clientToken)
  output <- .ssmincidents$update_replication_set_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$update_replication_set <- ssmincidents_update_replication_set

#' Updates the specified response plan
#'
#' @description
#' Updates the specified response plan.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_update_response_plan/](https://www.paws-r-sdk.com/docs/ssmincidents_update_response_plan/) for full documentation.
#'
#' @param actions The actions that this response plan takes at the beginning of an
#' incident.
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN) of the response plan.
#' @param chatChannel The Chatbot chat channel used for collaboration during an incident.
#' 
#' Use the empty structure to remove the chat channel from the response
#' plan.
#' @param clientToken A token ensuring that the operation is called only once with the
#' specified details.
#' @param displayName The long format name of the response plan. The display name can't
#' contain spaces.
#' @param engagements The Amazon Resource Name (ARN) for the contacts and escalation plans
#' that the response plan engages during an incident.
#' @param incidentTemplateDedupeString The string Incident Manager uses to prevent duplicate incidents from
#' being created by the same incident in the same account.
#' @param incidentTemplateImpact Defines the impact to the customers. Providing an impact overwrites the
#' impact provided by a response plan.
#' 
#' **Possible impacts:**
#' 
#' -   `5` - Severe impact
#' 
#' -   `4` - High impact
#' 
#' -   `3` - Medium impact
#' 
#' -   `2` - Low impact
#' 
#' -   `1` - No impact
#' @param incidentTemplateNotificationTargets The Amazon SNS targets that are notified when updates are made to an
#' incident.
#' @param incidentTemplateSummary A brief summary of the incident. This typically contains what has
#' happened, what's currently happening, and next steps.
#' @param incidentTemplateTags Tags to assign to the template. When the
#' [`start_incident`][ssmincidents_start_incident] API action is called,
#' Incident Manager assigns the tags specified in the template to the
#' incident. To call this action, you must also have permission to call the
#' [`tag_resource`][ssmincidents_tag_resource] API action for the incident
#' record resource.
#' @param incidentTemplateTitle The short format name of the incident. The title can't contain spaces.
#' @param integrations Information about third-party services integrated into the response
#' plan.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_update_response_plan
ssmincidents_update_response_plan <- function(actions = NULL, arn, chatChannel = NULL, clientToken = NULL, displayName = NULL, engagements = NULL, incidentTemplateDedupeString = NULL, incidentTemplateImpact = NULL, incidentTemplateNotificationTargets = NULL, incidentTemplateSummary = NULL, incidentTemplateTags = NULL, incidentTemplateTitle = NULL, integrations = NULL) {
  op <- new_operation(
    name = "UpdateResponsePlan",
    http_method = "POST",
    http_path = "/updateResponsePlan",
    paginator = list()
  )
  input <- .ssmincidents$update_response_plan_input(actions = actions, arn = arn, chatChannel = chatChannel, clientToken = clientToken, displayName = displayName, engagements = engagements, incidentTemplateDedupeString = incidentTemplateDedupeString, incidentTemplateImpact = incidentTemplateImpact, incidentTemplateNotificationTargets = incidentTemplateNotificationTargets, incidentTemplateSummary = incidentTemplateSummary, incidentTemplateTags = incidentTemplateTags, incidentTemplateTitle = incidentTemplateTitle, integrations = integrations)
  output <- .ssmincidents$update_response_plan_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$update_response_plan <- ssmincidents_update_response_plan

#' Updates a timeline event
#'
#' @description
#' Updates a timeline event. You can update events of type `Custom Event`.
#'
#' See [https://www.paws-r-sdk.com/docs/ssmincidents_update_timeline_event/](https://www.paws-r-sdk.com/docs/ssmincidents_update_timeline_event/) for full documentation.
#'
#' @param clientToken A token that ensures that a client calls the operation only once with
#' the specified details.
#' @param eventData A short description of the event.
#' @param eventId &#91;required&#93; The ID of the event to update. You can use
#' [`list_timeline_events`][ssmincidents_list_timeline_events] to find an
#' event's ID.
#' @param eventReferences Updates all existing references in a `TimelineEvent`. A reference is an
#' Amazon Web Services resource involved or associated with the incident.
#' To specify a reference, enter its Amazon Resource Name (ARN). You can
#' also specify a related item associated with that resource. For example,
#' to specify an Amazon DynamoDB (DynamoDB) table as a resource, use its
#' ARN. You can also specify an Amazon CloudWatch metric associated with
#' the DynamoDB table as a related item.
#' 
#' This update action overrides all existing references. If you want to
#' keep existing references, you must specify them in the call. If you
#' don't, this action removes any existing references and enters only new
#' references.
#' @param eventTime The time that the event occurred.
#' @param eventType The type of event. You can update events of type `Custom Event`.
#' @param incidentRecordArn &#91;required&#93; The Amazon Resource Name (ARN) of the incident that includes the
#' timeline event.
#'
#' @keywords internal
#'
#' @rdname ssmincidents_update_timeline_event
ssmincidents_update_timeline_event <- function(clientToken = NULL, eventData = NULL, eventId, eventReferences = NULL, eventTime = NULL, eventType = NULL, incidentRecordArn) {
  op <- new_operation(
    name = "UpdateTimelineEvent",
    http_method = "POST",
    http_path = "/updateTimelineEvent",
    paginator = list()
  )
  input <- .ssmincidents$update_timeline_event_input(clientToken = clientToken, eventData = eventData, eventId = eventId, eventReferences = eventReferences, eventTime = eventTime, eventType = eventType, incidentRecordArn = incidentRecordArn)
  output <- .ssmincidents$update_timeline_event_output()
  config <- get_config()
  svc <- .ssmincidents$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssmincidents$operations$update_timeline_event <- ssmincidents_update_timeline_event
