# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Application Auto Scaling
#'
#' @description
#' With Application Auto Scaling, you can configure automatic scaling for
#' the following resources:
#' 
#' -   Amazon AppStream 2.0 fleets
#' 
#' -   Amazon Aurora Replicas
#' 
#' -   Amazon Comprehend document classification and entity recognizer
#'     endpoints
#' 
#' -   Amazon DynamoDB tables and global secondary indexes throughput
#'     capacity
#' 
#' -   Amazon ECS services
#' 
#' -   Amazon ElastiCache for Redis clusters (replication groups)
#' 
#' -   Amazon EMR clusters
#' 
#' -   Amazon Keyspaces (for Apache Cassandra) tables
#' 
#' -   Lambda function provisioned concurrency
#' 
#' -   Amazon Managed Streaming for Apache Kafka broker storage
#' 
#' -   Amazon Neptune clusters
#' 
#' -   Amazon SageMaker endpoint variants
#' 
#' -   Amazon SageMaker Serverless endpoint provisioned concurrency
#' 
#' -   Amazon SageMaker inference components
#' 
#' -   Spot Fleets (Amazon EC2)
#' 
#' -   Custom resources provided by your own applications or services
#' 
#' To learn more about Application Auto Scaling, see the [Application Auto
#' Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html).
#' 
#' **API Summary**
#' 
#' The Application Auto Scaling service API includes three key sets of
#' actions:
#' 
#' -   Register and manage scalable targets - Register Amazon Web Services
#'     or custom resources as scalable targets (a resource that Application
#'     Auto Scaling can scale), set minimum and maximum capacity limits,
#'     and retrieve information on existing scalable targets.
#' 
#' -   Configure and manage automatic scaling - Define scaling policies to
#'     dynamically scale your resources in response to CloudWatch alarms,
#'     schedule one-time or recurring scaling actions, and retrieve your
#'     recent scaling activity history.
#' 
#' -   Suspend and resume scaling - Temporarily suspend and later resume
#'     automatic scaling by calling the
#'     [`register_scalable_target`][applicationautoscaling_register_scalable_target]
#'     API action for any Application Auto Scaling scalable target. You can
#'     suspend and resume (individually or in combination) scale-out
#'     activities that are triggered by a scaling policy, scale-in
#'     activities that are triggered by a scaling policy, and scheduled
#'     scaling.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- applicationautoscaling(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- applicationautoscaling()
#' # This example deletes a scaling policy for the Amazon ECS service called
#' # web-app, which is running in the default cluster.
#' svc$delete_scaling_policy(
#'   PolicyName = "web-app-cpu-lt-25",
#'   ResourceId = "service/default/web-app",
#'   ScalableDimension = "ecs:service:DesiredCount",
#'   ServiceNamespace = "ecs"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=applicationautoscaling_delete_scaling_policy]{delete_scaling_policy} \tab Deletes the specified scaling policy for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified scheduled action for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_deregister_scalable_target]{deregister_scalable_target} \tab Deregisters an Application Auto Scaling scalable target when you have finished using it\cr
#'  \link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets} \tab Gets information about the scalable targets in the specified namespace\cr
#'  \link[=applicationautoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks\cr
#'  \link[=applicationautoscaling_describe_scaling_policies]{describe_scaling_policies} \tab Describes the Application Auto Scaling scaling policies for the specified service namespace\cr
#'  \link[=applicationautoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Describes the Application Auto Scaling scheduled actions for the specified service namespace\cr
#'  \link[=applicationautoscaling_list_tags_for_resource]{list_tags_for_resource} \tab Returns all the tags on the specified Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a scaling policy for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_put_scheduled_action]{put_scheduled_action} \tab Creates or updates a scheduled action for an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_register_scalable_target]{register_scalable_target} \tab Registers or updates a scalable target, which is the resource that you want to scale\cr
#'  \link[=applicationautoscaling_tag_resource]{tag_resource} \tab Adds or edits tags on an Application Auto Scaling scalable target\cr
#'  \link[=applicationautoscaling_untag_resource]{untag_resource} \tab Deletes tags from an Application Auto Scaling scalable target
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname applicationautoscaling
#' @export
applicationautoscaling <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .applicationautoscaling$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.applicationautoscaling <- list()

.applicationautoscaling$operations <- list()

.applicationautoscaling$metadata <- list(
  service_name = "autoscaling",
  endpoints = list("*" = list(endpoint = "application-autoscaling.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "application-autoscaling.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "application-autoscaling.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "application-autoscaling.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Application Auto Scaling",
  api_version = "2016-02-06",
  signing_name = "application-autoscaling",
  json_version = "1.1",
  target_prefix = "AnyScaleFrontendService"
)

.applicationautoscaling$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.applicationautoscaling$metadata, handlers, config)
}
