% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_stop_logging}
\alias{cloudtrail_stop_logging}
\title{Suspends the recording of Amazon Web Services API calls and log file
delivery for the specified trail}
\usage{
cloudtrail_stop_logging(Name)
}
\arguments{
\item{Name}{[required] Specifies the name or the CloudTrail ARN of the trail for which
CloudTrail will stop logging Amazon Web Services API calls. The
following is the format of a trail ARN.

\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}}
}
\description{
Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the Region in which the trail was created, or an \code{InvalidHomeRegionException} will occur. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_stop_logging/} for full documentation.
}
\keyword{internal}
