# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Application Cost Profiler
#'
#' @description
#' This reference provides descriptions of the AWS Application Cost
#' Profiler API.
#' 
#' The AWS Application Cost Profiler API provides programmatic access to
#' view, create, update, and delete application cost report definitions, as
#' well as to import your usage data into the Application Cost Profiler
#' service.
#' 
#' For more information about using this service, see the [AWS Application
#' Cost Profiler User
#' Guide](https://docs.aws.amazon.com/application-cost-profiler/latest/userguide/introduction.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- applicationcostprofiler(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- applicationcostprofiler()
#' svc$delete_report_definition(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=applicationcostprofiler_delete_report_definition]{delete_report_definition} \tab Deletes the specified report definition in AWS Application Cost Profiler\cr
#'  \link[=applicationcostprofiler_get_report_definition]{get_report_definition} \tab Retrieves the definition of a report already configured in AWS Application Cost Profiler\cr
#'  \link[=applicationcostprofiler_import_application_usage]{import_application_usage} \tab Ingests application usage data from Amazon Simple Storage Service (Amazon S3)\cr
#'  \link[=applicationcostprofiler_list_report_definitions]{list_report_definitions} \tab Retrieves a list of all reports and their configurations for your AWS account\cr
#'  \link[=applicationcostprofiler_put_report_definition]{put_report_definition} \tab Creates the report definition for a report in Application Cost Profiler\cr
#'  \link[=applicationcostprofiler_update_report_definition]{update_report_definition} \tab Updates existing report in AWS Application Cost Profiler
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname applicationcostprofiler
#' @export
applicationcostprofiler <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .applicationcostprofiler$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.applicationcostprofiler <- list()

.applicationcostprofiler$operations <- list()

.applicationcostprofiler$metadata <- list(
  service_name = "applicationcostprofiler",
  endpoints = list("*" = list(endpoint = "application-cost-profiler.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "application-cost-profiler.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "application-cost-profiler.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "application-cost-profiler.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "application-cost-profiler.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "application-cost-profiler.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ApplicationCostProfiler",
  api_version = "2020-09-10",
  signing_name = "application-cost-profiler",
  json_version = "1.1",
  target_prefix = ""
)

.applicationcostprofiler$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.applicationcostprofiler$metadata, handlers, config)
}
