# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Control Tower
#'
#' @description
#' These interfaces allow you to apply the Amazon Web Services library of
#' pre-defined *controls* to your organizational units, programmatically.
#' In Amazon Web Services Control Tower, the terms "control" and
#' "guardrail" are synonyms.
#' 
#' To call these APIs, you'll need to know:
#' 
#' -   the `controlIdentifier` for the control--or guardrail--you are
#'     targeting.
#' 
#' -   the ARN associated with the target organizational unit (OU), which
#'     we call the `targetIdentifier`.
#' 
#' -   the ARN associated with a resource that you wish to tag or untag.
#' 
#' **To get the `controlIdentifier` for your Amazon Web Services Control
#' Tower control:**
#' 
#' The `controlIdentifier` is an ARN that is specified for each control.
#' You can view the `controlIdentifier` in the console on the **Control
#' details** page, as well as in the documentation.
#' 
#' The `controlIdentifier` is unique in each Amazon Web Services Region for
#' each control. You can find the `controlIdentifier` for each Region and
#' control in the [Tables of control
#' metadata](https://docs.aws.amazon.com/controltower/latest/controlreference/control-metadata-tables.html)
#' in the *Amazon Web Services Control Tower User Guide.*
#' 
#' A quick-reference list of control identifers for the Amazon Web Services
#' Control Tower legacy *Strongly recommended* and *Elective* controls is
#' given in [Resource identifiers for APIs and
#' controls](https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html)
#' in the [Controls reference guide
#' section](https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html)
#' of the *Amazon Web Services Control Tower User Guide*. Remember that
#' *Mandatory* controls cannot be added or removed.
#' 
#' **ARN format:** `arn:aws:controltower:{REGION}::control/{CONTROL_NAME}`
#' 
#' **Example:**
#' 
#' `arn:aws:controltower:us-west-2::control/AWS-GR_AUTOSCALING_LAUNCH_CONFIG_PUBLIC_IP_DISABLED`
#' 
#' **To get the `targetIdentifier`:**
#' 
#' The `targetIdentifier` is the ARN for an OU.
#' 
#' In the Amazon Web Services Organizations console, you can find the ARN
#' for the OU on the **Organizational unit details** page associated with
#' that OU.
#' 
#' **OU ARN format:**
#' 
#' `arn:${Partition}:organizations::${MasterAccountId}:ou/o-${OrganizationId}/ou-${OrganizationalUnitId}`
#' 
#' **Details and examples**
#' 
#' -   [Control API input and output examples with
#'     CLI](https://docs.aws.amazon.com/controltower/latest/controlreference/control-api-examples-short.html)
#' 
#' -   [Enable controls with
#'     CloudFormation](https://docs.aws.amazon.com/controltower/latest/controlreference/enable-controls.html)
#' 
#' -   [Control metadata
#'     tables](https://docs.aws.amazon.com/controltower/latest/controlreference/control-metadata-tables.html)
#' 
#' -   [List of identifiers for legacy
#'     controls](https://docs.aws.amazon.com/controltower/latest/controlreference/control-identifiers.html)
#' 
#' -   [Controls reference
#'     guide](https://docs.aws.amazon.com/controltower/latest/controlreference/controls.html)
#' 
#' -   [Controls library
#'     groupings](https://docs.aws.amazon.com/controltower/latest/controlreference/controls-reference.html)
#' 
#' -   [Creating Amazon Web Services Control Tower resources with Amazon
#'     Web Services
#'     CloudFormation](https://docs.aws.amazon.com/controltower/latest/userguide/creating-resources-with-cloudformation.html)
#' 
#' To view the open source resource repository on GitHub, see
#' [aws-cloudformation/aws-cloudformation-resource-providers-controltower](https://github.com/aws-cloudformation/aws-cloudformation-resource-providers-controltower)
#' 
#' **Recording API Requests**
#' 
#' Amazon Web Services Control Tower supports Amazon Web Services
#' CloudTrail, a service that records Amazon Web Services API calls for
#' your Amazon Web Services account and delivers log files to an Amazon S3
#' bucket. By using information collected by CloudTrail, you can determine
#' which requests the Amazon Web Services Control Tower service received,
#' who made the request and when, and so on. For more about Amazon Web
#' Services Control Tower and its support for CloudTrail, see [Logging
#' Amazon Web Services Control Tower Actions with Amazon Web Services
#' CloudTrail](https://docs.aws.amazon.com/controltower/latest/userguide/logging-using-cloudtrail.html)
#' in the Amazon Web Services Control Tower User Guide. To learn more about
#' CloudTrail, including how to turn it on and find your log files, see the
#' Amazon Web Services CloudTrail User Guide.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- controltower(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- controltower()
#' svc$create_landing_zone(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=controltower_create_landing_zone]{create_landing_zone} \tab Creates a new landing zone\cr
#'  \link[=controltower_delete_landing_zone]{delete_landing_zone} \tab Decommissions a landing zone\cr
#'  \link[=controltower_disable_baseline]{disable_baseline} \tab Disable an EnabledBaseline resource on the specified Target\cr
#'  \link[=controltower_disable_control]{disable_control} \tab This API call turns off a control\cr
#'  \link[=controltower_enable_baseline]{enable_baseline} \tab Enable (apply) a Baseline to a Target\cr
#'  \link[=controltower_enable_control]{enable_control} \tab This API call activates a control\cr
#'  \link[=controltower_get_baseline]{get_baseline} \tab Retrieve details about an existing Baseline resource by specifying its identifier\cr
#'  \link[=controltower_get_baseline_operation]{get_baseline_operation} \tab Returns the details of an asynchronous baseline operation, as initiated by any of these APIs: EnableBaseline, DisableBaseline, UpdateEnabledBaseline, ResetEnabledBaseline\cr
#'  \link[=controltower_get_control_operation]{get_control_operation} \tab Returns the status of a particular EnableControl or DisableControl operation\cr
#'  \link[=controltower_get_enabled_baseline]{get_enabled_baseline} \tab Retrieve details of an EnabledBaseline resource by specifying its identifier\cr
#'  \link[=controltower_get_enabled_control]{get_enabled_control} \tab Retrieves details about an enabled control\cr
#'  \link[=controltower_get_landing_zone]{get_landing_zone} \tab Returns details about the landing zone\cr
#'  \link[=controltower_get_landing_zone_operation]{get_landing_zone_operation} \tab Returns the status of the specified landing zone operation\cr
#'  \link[=controltower_list_baselines]{list_baselines} \tab Returns a summary list of all available baselines\cr
#'  \link[=controltower_list_enabled_baselines]{list_enabled_baselines} \tab Returns a list of summaries describing EnabledBaseline resources\cr
#'  \link[=controltower_list_enabled_controls]{list_enabled_controls} \tab Lists the controls enabled by Amazon Web Services Control Tower on the specified organizational unit and the accounts it contains\cr
#'  \link[=controltower_list_landing_zones]{list_landing_zones} \tab Returns the landing zone ARN for the landing zone deployed in your managed account\cr
#'  \link[=controltower_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags associated with the resource\cr
#'  \link[=controltower_reset_enabled_baseline]{reset_enabled_baseline} \tab Re-enables an EnabledBaseline resource\cr
#'  \link[=controltower_reset_landing_zone]{reset_landing_zone} \tab This API call resets a landing zone\cr
#'  \link[=controltower_tag_resource]{tag_resource} \tab Applies tags to a resource\cr
#'  \link[=controltower_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
#'  \link[=controltower_update_enabled_baseline]{update_enabled_baseline} \tab Updates an EnabledBaseline resource's applied parameters or version\cr
#'  \link[=controltower_update_enabled_control]{update_enabled_control} \tab Updates the configuration of an already enabled control\cr
#'  \link[=controltower_update_landing_zone]{update_landing_zone} \tab This API call updates the landing zone
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname controltower
#' @export
controltower <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .controltower$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.controltower <- list()

.controltower$operations <- list()

.controltower$metadata <- list(
  service_name = "controltower",
  endpoints = list("*" = list(endpoint = "controltower.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "controltower.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "controltower.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "controltower.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "controltower.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "controltower.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ControlTower",
  api_version = "2018-05-10",
  signing_name = "controltower",
  json_version = "1.1",
  target_prefix = ""
)

.controltower$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.controltower$metadata, handlers, config)
}
