# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Audit Manager
#'
#' @description
#' Welcome to the Audit Manager API reference. This guide is for developers
#' who need detailed information about the Audit Manager API operations,
#' data types, and errors.
#' 
#' Audit Manager is a service that provides automated evidence collection
#' so that you can continually audit your Amazon Web Services usage. You
#' can use it to assess the effectiveness of your controls, manage risk,
#' and simplify compliance.
#' 
#' Audit Manager provides prebuilt frameworks that structure and automate
#' assessments for a given compliance standard. Frameworks include a
#' prebuilt collection of controls with descriptions and testing
#' procedures. These controls are grouped according to the requirements of
#' the specified compliance standard or regulation. You can also customize
#' frameworks and controls to support internal audits with specific
#' requirements.
#' 
#' Use the following links to get started with the Audit Manager API:
#' 
#' -   [Actions](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Operations.html):
#'     An alphabetical list of all Audit Manager API operations.
#' 
#' -   [Data
#'     types](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Types.html):
#'     An alphabetical list of all Audit Manager data types.
#' 
#' -   [Common
#'     parameters](https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonParameters.html):
#'     Parameters that all operations can use.
#' 
#' -   [Common
#'     errors](https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonErrors.html):
#'     Client and server errors that all operations can return.
#' 
#' If you're new to Audit Manager, we recommend that you review the [Audit
#' Manager User
#' Guide](https://docs.aws.amazon.com/audit-manager/latest/userguide/what-is.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- auditmanager(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- auditmanager()
#' svc$associate_assessment_report_evidence_folder(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=auditmanager_associate_assessment_report_evidence_folder]{associate_assessment_report_evidence_folder} \tab Associates an evidence folder to an assessment report in an Audit Manager assessment\cr
#'  \link[=auditmanager_batch_associate_assessment_report_evidence]{batch_associate_assessment_report_evidence} \tab Associates a list of evidence to an assessment report in an Audit Manager assessment\cr
#'  \link[=auditmanager_batch_create_delegation_by_assessment]{batch_create_delegation_by_assessment} \tab Creates a batch of delegations for an assessment in Audit Manager\cr
#'  \link[=auditmanager_batch_delete_delegation_by_assessment]{batch_delete_delegation_by_assessment} \tab Deletes a batch of delegations for an assessment in Audit Manager\cr
#'  \link[=auditmanager_batch_disassociate_assessment_report_evidence]{batch_disassociate_assessment_report_evidence} \tab Disassociates a list of evidence from an assessment report in Audit Manager\cr
#'  \link[=auditmanager_batch_import_evidence_to_assessment_control]{batch_import_evidence_to_assessment_control} \tab Adds one or more pieces of evidence to a control in an Audit Manager assessment\cr
#'  \link[=auditmanager_create_assessment]{create_assessment} \tab Creates an assessment in Audit Manager\cr
#'  \link[=auditmanager_create_assessment_framework]{create_assessment_framework} \tab Creates a custom framework in Audit Manager\cr
#'  \link[=auditmanager_create_assessment_report]{create_assessment_report} \tab Creates an assessment report for the specified assessment\cr
#'  \link[=auditmanager_create_control]{create_control} \tab Creates a new custom control in Audit Manager\cr
#'  \link[=auditmanager_delete_assessment]{delete_assessment} \tab Deletes an assessment in Audit Manager\cr
#'  \link[=auditmanager_delete_assessment_framework]{delete_assessment_framework} \tab Deletes a custom framework in Audit Manager\cr
#'  \link[=auditmanager_delete_assessment_framework_share]{delete_assessment_framework_share} \tab Deletes a share request for a custom framework in Audit Manager\cr
#'  \link[=auditmanager_delete_assessment_report]{delete_assessment_report} \tab Deletes an assessment report in Audit Manager\cr
#'  \link[=auditmanager_delete_control]{delete_control} \tab Deletes a custom control in Audit Manager\cr
#'  \link[=auditmanager_deregister_account]{deregister_account} \tab Deregisters an account in Audit Manager\cr
#'  \link[=auditmanager_deregister_organization_admin_account]{deregister_organization_admin_account} \tab Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager\cr
#'  \link[=auditmanager_disassociate_assessment_report_evidence_folder]{disassociate_assessment_report_evidence_folder} \tab Disassociates an evidence folder from the specified assessment report in Audit Manager\cr
#'  \link[=auditmanager_get_account_status]{get_account_status} \tab Gets the registration status of an account in Audit Manager\cr
#'  \link[=auditmanager_get_assessment]{get_assessment} \tab Gets information about a specified assessment\cr
#'  \link[=auditmanager_get_assessment_framework]{get_assessment_framework} \tab Gets information about a specified framework\cr
#'  \link[=auditmanager_get_assessment_report_url]{get_assessment_report_url} \tab Gets the URL of an assessment report in Audit Manager\cr
#'  \link[=auditmanager_get_change_logs]{get_change_logs} \tab Gets a list of changelogs from Audit Manager\cr
#'  \link[=auditmanager_get_control]{get_control} \tab Gets information about a specified control\cr
#'  \link[=auditmanager_get_delegations]{get_delegations} \tab Gets a list of delegations from an audit owner to a delegate\cr
#'  \link[=auditmanager_get_evidence]{get_evidence} \tab Gets information about a specified evidence item\cr
#'  \link[=auditmanager_get_evidence_by_evidence_folder]{get_evidence_by_evidence_folder} \tab Gets all evidence from a specified evidence folder in Audit Manager\cr
#'  \link[=auditmanager_get_evidence_file_upload_url]{get_evidence_file_upload_url} \tab Creates a presigned Amazon S3 URL that can be used to upload a file as manual evidence\cr
#'  \link[=auditmanager_get_evidence_folder]{get_evidence_folder} \tab Gets an evidence folder from a specified assessment in Audit Manager\cr
#'  \link[=auditmanager_get_evidence_folders_by_assessment]{get_evidence_folders_by_assessment} \tab Gets the evidence folders from a specified assessment in Audit Manager\cr
#'  \link[=auditmanager_get_evidence_folders_by_assessment_control]{get_evidence_folders_by_assessment_control} \tab Gets a list of evidence folders that are associated with a specified control in an Audit Manager assessment\cr
#'  \link[=auditmanager_get_insights]{get_insights} \tab Gets the latest analytics data for all your current active assessments\cr
#'  \link[=auditmanager_get_insights_by_assessment]{get_insights_by_assessment} \tab Gets the latest analytics data for a specific active assessment\cr
#'  \link[=auditmanager_get_organization_admin_account]{get_organization_admin_account} \tab Gets the name of the delegated Amazon Web Services administrator account for a specified organization\cr
#'  \link[=auditmanager_get_services_in_scope]{get_services_in_scope} \tab Gets a list of the Amazon Web Services from which Audit Manager can collect evidence\cr
#'  \link[=auditmanager_get_settings]{get_settings} \tab Gets the settings for a specified Amazon Web Services account\cr
#'  \link[=auditmanager_list_assessment_control_insights_by_control_domain]{list_assessment_control_insights_by_control_domain} \tab Lists the latest analytics data for controls within a specific control domain and a specific active assessment\cr
#'  \link[=auditmanager_list_assessment_frameworks]{list_assessment_frameworks} \tab Returns a list of the frameworks that are available in the Audit Manager framework library\cr
#'  \link[=auditmanager_list_assessment_framework_share_requests]{list_assessment_framework_share_requests} \tab Returns a list of sent or received share requests for custom frameworks in Audit Manager\cr
#'  \link[=auditmanager_list_assessment_reports]{list_assessment_reports} \tab Returns a list of assessment reports created in Audit Manager\cr
#'  \link[=auditmanager_list_assessments]{list_assessments} \tab Returns a list of current and past assessments from Audit Manager\cr
#'  \link[=auditmanager_list_control_domain_insights]{list_control_domain_insights} \tab Lists the latest analytics data for control domains across all of your active assessments\cr
#'  \link[=auditmanager_list_control_domain_insights_by_assessment]{list_control_domain_insights_by_assessment} \tab Lists analytics data for control domains within a specified active assessment\cr
#'  \link[=auditmanager_list_control_insights_by_control_domain]{list_control_insights_by_control_domain} \tab Lists the latest analytics data for controls within a specific control domain across all active assessments\cr
#'  \link[=auditmanager_list_controls]{list_controls} \tab Returns a list of controls from Audit Manager\cr
#'  \link[=auditmanager_list_keywords_for_data_source]{list_keywords_for_data_source} \tab Returns a list of keywords that are pre-mapped to the specified control data source\cr
#'  \link[=auditmanager_list_notifications]{list_notifications} \tab Returns a list of all Audit Manager notifications\cr
#'  \link[=auditmanager_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags for the specified resource in Audit Manager\cr
#'  \link[=auditmanager_register_account]{register_account} \tab Enables Audit Manager for the specified Amazon Web Services account\cr
#'  \link[=auditmanager_register_organization_admin_account]{register_organization_admin_account} \tab Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager\cr
#'  \link[=auditmanager_start_assessment_framework_share]{start_assessment_framework_share} \tab Creates a share request for a custom framework in Audit Manager\cr
#'  \link[=auditmanager_tag_resource]{tag_resource} \tab Tags the specified resource in Audit Manager\cr
#'  \link[=auditmanager_untag_resource]{untag_resource} \tab Removes a tag from a resource in Audit Manager\cr
#'  \link[=auditmanager_update_assessment]{update_assessment} \tab Edits an Audit Manager assessment\cr
#'  \link[=auditmanager_update_assessment_control]{update_assessment_control} \tab Updates a control within an assessment in Audit Manager\cr
#'  \link[=auditmanager_update_assessment_control_set_status]{update_assessment_control_set_status} \tab Updates the status of a control set in an Audit Manager assessment\cr
#'  \link[=auditmanager_update_assessment_framework]{update_assessment_framework} \tab Updates a custom framework in Audit Manager\cr
#'  \link[=auditmanager_update_assessment_framework_share]{update_assessment_framework_share} \tab Updates a share request for a custom framework in Audit Manager\cr
#'  \link[=auditmanager_update_assessment_status]{update_assessment_status} \tab Updates the status of an assessment in Audit Manager\cr
#'  \link[=auditmanager_update_control]{update_control} \tab Updates a custom control in Audit Manager\cr
#'  \link[=auditmanager_update_settings]{update_settings} \tab Updates Audit Manager settings for the current account\cr
#'  \link[=auditmanager_validate_assessment_report_integrity]{validate_assessment_report_integrity} \tab Validates the integrity of an assessment report in Audit Manager
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname auditmanager
#' @export
auditmanager <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .auditmanager$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.auditmanager <- list()

.auditmanager$operations <- list()

.auditmanager$metadata <- list(
  service_name = "auditmanager",
  endpoints = list("*" = list(endpoint = "auditmanager.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "auditmanager.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "auditmanager.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "auditmanager.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "auditmanager.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "auditmanager.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "AuditManager",
  api_version = "2017-07-25",
  signing_name = "auditmanager",
  json_version = "1.1",
  target_prefix = ""
)

.auditmanager$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.auditmanager$metadata, handlers, config, op)
}
