% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworkscm_operations.R
\name{opsworkscm_list_tags_for_resource}
\alias{opsworkscm_list_tags_for_resource}
\title{Returns a list of tags that are applied to the specified AWS OpsWorks
for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or
backups}
\usage{
opsworkscm_list_tags_for_resource(
  ResourceArn,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Number (ARN) of an AWS OpsWorks for Chef Automate or
AWS OpsWorks for Puppet Enterprise server for which you want to show
applied tags. For example,
\verb{arn:aws:opsworks-cm:us-west-2:123456789012:server/test-owcm-server/EXAMPLE-66b0-4196-8274-d1a2bEXAMPLE}.}

\item{NextToken}{NextToken is a string that is returned in some command responses. It
indicates that not all entries have been returned, and that you must run
at least one more request to get remaining items. To get remaining
results, call
\code{\link[=opsworkscm_list_tags_for_resource]{list_tags_for_resource}} again, and
assign the token from the previous results as the value of the
\code{nextToken} parameter. If there are no more results, the response
object's \code{nextToken} parameter value is \code{null}. Setting a \code{nextToken}
value that was not returned in your previous results causes an
\code{InvalidNextTokenException} to occur.}

\item{MaxResults}{To receive a paginated response, use this parameter to specify the
maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}
}
\description{
Returns a list of tags that are applied to the specified AWS OpsWorks for Chef Automate or AWS OpsWorks for Puppet Enterprise servers or backups.

See \url{https://www.paws-r-sdk.com/docs/opsworkscm_list_tags_for_resource/} for full documentation.
}
\keyword{internal}
