% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_attach_policy}
\alias{organizations_attach_policy}
\title{Attaches a policy to a root, an organizational unit (OU), or an
individual account}
\usage{
organizations_attach_policy(PolicyId, TargetId)
}
\arguments{
\item{PolicyId}{[required] The unique identifier (ID) of the policy that you want to attach to the
target. You can get the ID for the policy by calling the
\code{\link[=organizations_list_policies]{list_policies}} operation.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a policy ID
string requires "p-" followed by from 8 to 128 lowercase or uppercase
letters, digits, or the underscore character (_).}

\item{TargetId}{[required] The unique identifier (ID) of the root, OU, or account that you want to
attach the policy to. You can get the ID by calling the
\code{\link[=organizations_list_roots]{list_roots}},
\code{\link[=organizations_list_organizational_units_for_parent]{list_organizational_units_for_parent}},
or \code{\link[=organizations_list_accounts]{list_accounts}} operations.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a target ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with "r-" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Account} - A string that consists of exactly 12 digits.
\item \strong{Organizational unit (OU)} - A string that begins with "ou-"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second "-"
dash and from 8 to 32 additional lowercase letters or digits.
}}
}
\description{
Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the \emph{Organizations User Guide} for information about each policy type:

See \url{https://www.paws-r-sdk.com/docs/organizations_attach_policy/} for full documentation.
}
\keyword{internal}
