% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_start_incident}
\alias{ssmincidents_start_incident}
\title{Used to start an incident from CloudWatch alarms, EventBridge events, or
manually}
\usage{
ssmincidents_start_incident(
  clientToken = NULL,
  impact = NULL,
  relatedItems = NULL,
  responsePlanArn,
  title = NULL,
  triggerDetails = NULL
)
}
\arguments{
\item{clientToken}{A token ensuring that the operation is called only once with the
specified details.}

\item{impact}{Defines the impact to the customers. Providing an impact overwrites the
impact provided by a response plan.

\strong{Supported impact codes}
\itemize{
\item \code{1} - Critical
\item \code{2} - High
\item \code{3} - Medium
\item \code{4} - Low
\item \code{5} - No Impact
}}

\item{relatedItems}{Add related items to the incident for other responders to use. Related
items are Amazon Web Services resources, external links, or files
uploaded to an Amazon S3 bucket.}

\item{responsePlanArn}{[required] The Amazon Resource Name (ARN) of the response plan that pre-defines
summary, chat channels, Amazon SNS topics, runbooks, title, and impact
of the incident.}

\item{title}{Provide a title for the incident. Providing a title overwrites the title
provided by the response plan.}

\item{triggerDetails}{Details of what created the incident record in Incident Manager.}
}
\description{
Used to start an incident from CloudWatch alarms, EventBridge events, or manually.

See \url{https://www.paws-r-sdk.com/docs/ssmincidents_start_incident/} for full documentation.
}
\keyword{internal}
