% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_delete_streaming_distribution}
\alias{cloudfront_delete_streaming_distribution}
\title{Delete a streaming distribution}
\usage{
cloudfront_delete_streaming_distribution(Id, IfMatch)
}
\arguments{
\item{Id}{[required] The distribution ID.}

\item{IfMatch}{The value of the \code{ETag} header that you received when you disabled the
streaming distribution. For example: \code{E2QWRUHAPOMQZL}.}
}
\description{
Delete a streaming distribution. To delete an RTMP distribution using
the CloudFront API, perform the following steps.
}
\details{
\strong{To delete an RTMP distribution using the CloudFront API}:
\enumerate{
\item Disable the RTMP distribution.
\item Submit a \code{GET Streaming Distribution Config} request to get the
current configuration and the \code{Etag} header for the distribution.
\item Update the XML document that was returned in the response to your
\code{GET Streaming Distribution Config} request to change the value of
\code{Enabled} to \code{false}.
\item Submit a \code{PUT Streaming Distribution Config} request to update the
configuration for your distribution. In the request body, include
the XML document that you updated in Step 3. Then set the value of
the HTTP \code{If-Match} header to the value of the \code{ETag} header that
CloudFront returned when you submitted the
\code{GET Streaming Distribution Config} request in Step 2.
\item Review the response to the \code{PUT Streaming Distribution Config}
request to confirm that the distribution was successfully disabled.
\item Submit a \code{GET Streaming Distribution Config} request to confirm that
your changes have propagated. When propagation is complete, the
value of \code{Status} is \code{Deployed}.
\item Submit a \code{DELETE Streaming Distribution} request. Set the value of
the HTTP \code{If-Match} header to the value of the \code{ETag} header that
CloudFront returned when you submitted the
\code{GET Streaming Distribution Config} request in Step 2.
\item Review the response to your \code{DELETE Streaming Distribution} request
to confirm that the distribution was successfully deleted.
}

For information about deleting a distribution using the CloudFront
console, see \href{http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html}{Deleting a Distribution}
in the \emph{Amazon CloudFront Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_streaming_distribution(
  Id = "string",
  IfMatch = "string"
)
}
}

\keyword{internal}
