% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_accept_direct_connect_gateway_association_proposal}
\alias{directconnect_accept_direct_connect_gateway_association_proposal}
\title{Accepts a proposal request to attach a virtual private gateway to a
Direct Connect gateway}
\usage{
directconnect_accept_direct_connect_gateway_association_proposal(
  directConnectGatewayId, proposalId, associatedGatewayOwnerAccount,
  overrideAllowedPrefixesToDirectConnectGateway)
}
\arguments{
\item{directConnectGatewayId}{[required] The ID of the Direct Connect gateway.}

\item{proposalId}{[required] The ID of the request proposal.}

\item{associatedGatewayOwnerAccount}{[required] The ID of the AWS account that owns the virtual private gateway.}

\item{overrideAllowedPrefixesToDirectConnectGateway}{Overrides the Amazon VPC prefixes advertised to the Direct Connect
gateway.}
}
\description{
Accepts a proposal request to attach a virtual private gateway to a
Direct Connect gateway.
}
\section{Request syntax}{
\preformatted{svc$accept_direct_connect_gateway_association_proposal(
  directConnectGatewayId = "string",
  proposalId = "string",
  associatedGatewayOwnerAccount = "string",
  overrideAllowedPrefixesToDirectConnectGateway = list(
    list(
      cidr = "string"
    )
  )
)
}
}

\keyword{internal}
