% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_rule}
\alias{elbv2_modify_rule}
\title{Modifies the specified rule}
\usage{
elbv2_modify_rule(RuleArn, Conditions, Actions)
}
\arguments{
\item{RuleArn}{[required] The Amazon Resource Name (ARN) of the rule.}

\item{Conditions}{The conditions. Each condition specifies a field name and a single
value.

If the field name is \code{host-header}, you can specify a single host name
(for example, my.example.com). A host name is case insensitive, can be
up to 128 characters in length, and can contain any of the following
characters. You can include up to three wildcard characters.
\itemize{
\item A-Z, a-z, 0-9
\item \- .
\item * (matches 0 or more characters)
\item ? (matches exactly 1 character)
}

If the field name is \code{path-pattern}, you can specify a single path
pattern. A path pattern is case-sensitive, can be up to 128 characters
in length, and can contain any of the following characters. You can
include up to three wildcard characters.
\itemize{
\item A-Z, a-z, 0-9
\item \_ - . \$ / ~ " ' @ : +
\item & (using &)
\item * (matches 0 or more characters)
\item ? (matches exactly 1 character)
}}

\item{Actions}{The actions.

If the action type is \code{forward}, you specify a target group. The
protocol of the target group must be HTTP or HTTPS for an Application
Load Balancer. The protocol of the target group must be TCP or TLS for a
Network Load Balancer.

[HTTPS listeners] If the action type is \code{authenticate-oidc}, you
authenticate users through an identity provider that is OpenID Connect
(OIDC) compliant.

[HTTPS listeners] If the action type is \code{authenticate-cognito}, you
authenticate users through the user pools supported by Amazon Cognito.

[Application Load Balancer] If the action type is \code{redirect}, you
redirect specified client requests from one URL to another.

[Application Load Balancer] If the action type is \code{fixed-response},
you drop specified client requests and return a custom HTTP response.}
}
\description{
Modifies the specified rule.
}
\details{
Any existing properties that you do not modify retain their current
values.

To modify the actions for the default rule, use ModifyListener.
}
\section{Request syntax}{
\preformatted{svc$modify_rule(
  RuleArn = "string",
  Conditions = list(
    list(
      Field = "string",
      Values = list(
        "string"
      ),
      HostHeaderConfig = list(
        Values = list(
          "string"
        )
      ),
      PathPatternConfig = list(
        Values = list(
          "string"
        )
      ),
      HttpHeaderConfig = list(
        HttpHeaderName = "string",
        Values = list(
          "string"
        )
      ),
      QueryStringConfig = list(
        Values = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      ),
      HttpRequestMethodConfig = list(
        Values = list(
          "string"
        )
      ),
      SourceIpConfig = list(
        Values = list(
          "string"
        )
      )
    )
  ),
  Actions = list(
    list(
      Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
      TargetGroupArn = "string",
      AuthenticateOidcConfig = list(
        Issuer = "string",
        AuthorizationEndpoint = "string",
        TokenEndpoint = "string",
        UserInfoEndpoint = "string",
        ClientId = "string",
        ClientSecret = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
        UseExistingClientSecret = TRUE|FALSE
      ),
      AuthenticateCognitoConfig = list(
        UserPoolArn = "string",
        UserPoolClientId = "string",
        UserPoolDomain = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
      ),
      Order = 123,
      RedirectConfig = list(
        Protocol = "string",
        Port = "string",
        Host = "string",
        Path = "string",
        Query = "string",
        StatusCode = "HTTP_301"|"HTTP_302"
      ),
      FixedResponseConfig = list(
        MessageBody = "string",
        StatusCode = "string",
        ContentType = "string"
      )
    )
  )
)
}
}

\examples{
# This example modifies the condition for the specified rule.
\donttest{svc$modify_rule(
  Conditions = list(
    list(
      Field = "path-pattern",
      Values = list(
        "/images/*"
      )
    )
  ),
  RuleArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-load-b..."
)}

}
\keyword{internal}
