% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_private_virtual_interface}
\alias{directconnect_create_private_virtual_interface}
\title{Creates a private virtual interface}
\usage{
directconnect_create_private_virtual_interface(connectionId,
  newPrivateVirtualInterface)
}
\arguments{
\item{connectionId}{[required] The ID of the connection.}

\item{newPrivateVirtualInterface}{[required] Information about the private virtual interface.}
}
\description{
Creates a private virtual interface. A virtual interface is the VLAN
that transports AWS Direct Connect traffic. A private virtual interface
can be connected to either a Direct Connect gateway or a Virtual Private
Gateway (VGW). Connecting the private virtual interface to a Direct
Connect gateway enables the possibility for connecting to multiple VPCs,
including VPCs in different AWS Regions. Connecting the private virtual
interface to a VGW only provides access to a single VPC within the same
Region.

Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause
an update to the underlying physical connection if it wasn't updated to
support jumbo frames. Updating the connection disrupts network
connectivity for all virtual interfaces associated with the connection
for up to 30 seconds. To check whether your connection supports jumbo
frames, call DescribeConnections. To check whether your virtual
interface supports jumbo frames, call DescribeVirtualInterfaces.
}
\section{Request syntax}{
\preformatted{svc$create_private_virtual_interface(
  connectionId = "string",
  newPrivateVirtualInterface = list(
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    mtu = 123,
    authKey = "string",
    amazonAddress = "string",
    customerAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    virtualGatewayId = "string",
    directConnectGatewayId = "string",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
