% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_cancel_domain_transfer_to_another_aws_account}
\alias{route53domains_cancel_domain_transfer_to_another_aws_account}
\title{Cancels the transfer of a domain from the current AWS account to another
AWS account}
\usage{
route53domains_cancel_domain_transfer_to_another_aws_account(DomainName)
}
\arguments{
\item{DomainName}{[required] The name of the domain for which you want to cancel the transfer to
another AWS account.}
}
\description{
Cancels the transfer of a domain from the current AWS account to another
AWS account. You initiate a transfer between AWS accounts using
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html}{TransferDomainToAnotherAwsAccount}.

You must cancel the transfer before the other AWS account accepts the
transfer using
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html}{AcceptDomainTransferFromAnotherAwsAccount}.

Use either
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html}{ListOperations}
or
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html}{GetOperationDetail}
to determine whether the operation succeeded.
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html}{GetOperationDetail}
provides additional information, for example,
\verb{Domain Transfer from Aws Account 111122223333 has been cancelled}.
}
\section{Request syntax}{
\preformatted{svc$cancel_domain_transfer_to_another_aws_account(
  DomainName = "string"
)
}
}

\keyword{internal}
