% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_mesh}
\alias{appmesh_update_mesh}
\title{Updates an existing service mesh}
\usage{
appmesh_update_mesh(clientToken, meshName, spec)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh to update.}

\item{spec}{The service mesh specification to apply.}
}
\value{
A list with the following syntax:\preformatted{list(
  mesh = list(
    meshName = "string",
    metadata = list(
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      meshOwner = "string",
      resourceOwner = "string",
      uid = "string",
      version = 123
    ),
    spec = list(
      egressFilter = list(
        type = "ALLOW_ALL"|"DROP_ALL"
      )
    ),
    status = list(
      status = "ACTIVE"|"INACTIVE"|"DELETED"
    )
  )
)
}
}
\description{
Updates an existing service mesh.
}
\section{Request syntax}{
\preformatted{svc$update_mesh(
  clientToken = "string",
  meshName = "string",
  spec = list(
    egressFilter = list(
      type = "ALLOW_ALL"|"DROP_ALL"
    )
  )
)
}
}

\keyword{internal}
