% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_get_integrations}
\alias{apigatewayv2_get_integrations}
\title{Gets the Integrations for an API}
\usage{
apigatewayv2_get_integrations(ApiId, MaxResults, NextToken)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{MaxResults}{The maximum number of elements to be returned for this resource.}

\item{NextToken}{The next page of elements from this collection. Not valid for the last
element of the collection.}
}
\value{
A list with the following syntax:\preformatted{list(
  Items = list(
    list(
      ApiGatewayManaged = TRUE|FALSE,
      ConnectionId = "string",
      ConnectionType = "INTERNET"|"VPC_LINK",
      ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
      CredentialsArn = "string",
      Description = "string",
      IntegrationId = "string",
      IntegrationMethod = "string",
      IntegrationResponseSelectionExpression = "string",
      IntegrationSubtype = "string",
      IntegrationType = "AWS"|"HTTP"|"MOCK"|"HTTP_PROXY"|"AWS_PROXY",
      IntegrationUri = "string",
      PassthroughBehavior = "WHEN_NO_MATCH"|"NEVER"|"WHEN_NO_TEMPLATES",
      PayloadFormatVersion = "string",
      RequestParameters = list(
        "string"
      ),
      RequestTemplates = list(
        "string"
      ),
      ResponseParameters = list(
        list(
          "string"
        )
      ),
      TemplateSelectionExpression = "string",
      TimeoutInMillis = 123,
      TlsConfig = list(
        ServerNameToVerify = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets the Integrations for an API.
}
\section{Request syntax}{
\preformatted{svc$get_integrations(
  ApiId = "string",
  MaxResults = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
