% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_describe_endpoint_group}
\alias{globalaccelerator_describe_endpoint_group}
\title{Describe an endpoint group}
\usage{
globalaccelerator_describe_endpoint_group(EndpointGroupArn)
}
\arguments{
\item{EndpointGroupArn}{[required] The Amazon Resource Name (ARN) of the endpoint group to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  EndpointGroup = list(
    EndpointGroupArn = "string",
    EndpointGroupRegion = "string",
    EndpointDescriptions = list(
      list(
        EndpointId = "string",
        Weight = 123,
        HealthState = "INITIAL"|"HEALTHY"|"UNHEALTHY",
        HealthReason = "string",
        ClientIPPreservationEnabled = TRUE|FALSE
      )
    ),
    TrafficDialPercentage = 123.0,
    HealthCheckPort = 123,
    HealthCheckProtocol = "TCP"|"HTTP"|"HTTPS",
    HealthCheckPath = "string",
    HealthCheckIntervalSeconds = 123,
    ThresholdCount = 123,
    PortOverrides = list(
      list(
        ListenerPort = 123,
        EndpointPort = 123
      )
    )
  )
)
}
}
\description{
Describe an endpoint group.
}
\section{Request syntax}{
\preformatted{svc$describe_endpoint_group(
  EndpointGroupArn = "string"
)
}
}

\keyword{internal}
