% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_service.R
\name{cloudfront}
\alias{cloudfront}
\title{Amazon CloudFront}
\usage{
cloudfront(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
This is the \emph{Amazon CloudFront API Reference}. This guide is for
developers who need detailed information about CloudFront API actions,
data types, and errors. For detailed information about CloudFront
features, see the \emph{Amazon CloudFront Developer Guide}.
}
\section{Service syntax}{
\preformatted{svc <- cloudfront(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=cloudfront_create_cloud_front_origin_access_identity]{create_cloud_front_origin_access_identity} \tab Creates a new origin access identity \cr
\link[=cloudfront_create_distribution]{create_distribution} \tab Creates a new web distribution \cr
\link[=cloudfront_create_distribution_with_tags]{create_distribution_with_tags} \tab Create a new distribution with tags \cr
\link[=cloudfront_create_field_level_encryption_config]{create_field_level_encryption_config} \tab Create a new field-level encryption configuration \cr
\link[=cloudfront_create_field_level_encryption_profile]{create_field_level_encryption_profile} \tab Create a field-level encryption profile \cr
\link[=cloudfront_create_invalidation]{create_invalidation} \tab Create a new invalidation \cr
\link[=cloudfront_create_public_key]{create_public_key} \tab Add a new public key to CloudFront to use, for example, for field-level encryption \cr
\link[=cloudfront_create_streaming_distribution]{create_streaming_distribution} \tab Creates a new RTMP distribution \cr
\link[=cloudfront_create_streaming_distribution_with_tags]{create_streaming_distribution_with_tags} \tab Create a new streaming distribution with tags \cr
\link[=cloudfront_delete_cloud_front_origin_access_identity]{delete_cloud_front_origin_access_identity} \tab Delete an origin access identity \cr
\link[=cloudfront_delete_distribution]{delete_distribution} \tab Delete a distribution \cr
\link[=cloudfront_delete_field_level_encryption_config]{delete_field_level_encryption_config} \tab Remove a field-level encryption configuration \cr
\link[=cloudfront_delete_field_level_encryption_profile]{delete_field_level_encryption_profile} \tab Remove a field-level encryption profile \cr
\link[=cloudfront_delete_public_key]{delete_public_key} \tab Remove a public key you previously added to CloudFront \cr
\link[=cloudfront_delete_streaming_distribution]{delete_streaming_distribution} \tab Delete a streaming distribution \cr
\link[=cloudfront_get_cloud_front_origin_access_identity]{get_cloud_front_origin_access_identity} \tab Get the information about an origin access identity \cr
\link[=cloudfront_get_cloud_front_origin_access_identity_config]{get_cloud_front_origin_access_identity_config} \tab Get the configuration information about an origin access identity \cr
\link[=cloudfront_get_distribution]{get_distribution} \tab Get the information about a distribution \cr
\link[=cloudfront_get_distribution_config]{get_distribution_config} \tab Get the configuration information about a distribution \cr
\link[=cloudfront_get_field_level_encryption]{get_field_level_encryption} \tab Get the field-level encryption configuration information \cr
\link[=cloudfront_get_field_level_encryption_config]{get_field_level_encryption_config} \tab Get the field-level encryption configuration information \cr
\link[=cloudfront_get_field_level_encryption_profile]{get_field_level_encryption_profile} \tab Get the field-level encryption profile information \cr
\link[=cloudfront_get_field_level_encryption_profile_config]{get_field_level_encryption_profile_config} \tab Get the field-level encryption profile configuration information \cr
\link[=cloudfront_get_invalidation]{get_invalidation} \tab Get the information about an invalidation \cr
\link[=cloudfront_get_public_key]{get_public_key} \tab Get the public key information \cr
\link[=cloudfront_get_public_key_config]{get_public_key_config} \tab Return public key configuration informaation \cr
\link[=cloudfront_get_streaming_distribution]{get_streaming_distribution} \tab Gets information about a specified RTMP distribution, including the distribution configuration \cr
\link[=cloudfront_get_streaming_distribution_config]{get_streaming_distribution_config} \tab Get the configuration information about a streaming distribution \cr
\link[=cloudfront_list_cloud_front_origin_access_identities]{list_cloud_front_origin_access_identities} \tab Lists origin access identities \cr
\link[=cloudfront_list_distributions]{list_distributions} \tab List CloudFront distributions \cr
\link[=cloudfront_list_distributions_by_web_acl_id]{list_distributions_by_web_acl_id} \tab List the distributions that are associated with a specified AWS WAF web ACL \cr
\link[=cloudfront_list_field_level_encryption_configs]{list_field_level_encryption_configs} \tab List all field-level encryption configurations that have been created in CloudFront for this account \cr
\link[=cloudfront_list_field_level_encryption_profiles]{list_field_level_encryption_profiles} \tab Request a list of field-level encryption profiles that have been created in CloudFront for this account\cr
\link[=cloudfront_list_invalidations]{list_invalidations} \tab Lists invalidation batches \cr
\link[=cloudfront_list_public_keys]{list_public_keys} \tab List all public keys that have been added to CloudFront for this account \cr
\link[=cloudfront_list_streaming_distributions]{list_streaming_distributions} \tab List streaming distributions \cr
\link[=cloudfront_list_tags_for_resource]{list_tags_for_resource} \tab List tags for a CloudFront resource \cr
\link[=cloudfront_tag_resource]{tag_resource} \tab Add tags to a CloudFront resource \cr
\link[=cloudfront_untag_resource]{untag_resource} \tab Remove tags from a CloudFront resource \cr
\link[=cloudfront_update_cloud_front_origin_access_identity]{update_cloud_front_origin_access_identity} \tab Update an origin access identity \cr
\link[=cloudfront_update_distribution]{update_distribution} \tab Updates the configuration for a web distribution \cr
\link[=cloudfront_update_field_level_encryption_config]{update_field_level_encryption_config} \tab Update a field-level encryption configuration \cr
\link[=cloudfront_update_field_level_encryption_profile]{update_field_level_encryption_profile} \tab Update a field-level encryption profile \cr
\link[=cloudfront_update_public_key]{update_public_key} \tab Update public key information \cr
\link[=cloudfront_update_streaming_distribution]{update_streaming_distribution} \tab Update a streaming distribution
}
}

\examples{
\donttest{svc <- cloudfront()
svc$create_cloud_front_origin_access_identity(
  Foo = 123
)}

}
