% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_add_listener_certificates}
\alias{elbv2_add_listener_certificates}
\title{Adds the specified SSL server certificate to the certificate list for
the specified HTTPS listener}
\usage{
elbv2_add_listener_certificates(ListenerArn, Certificates)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{Certificates}{[required] The certificate to add. You can specify one certificate per call. Set
\code{CertificateArn} to the certificate ARN but do not set \code{IsDefault}.}
}
\description{
Adds the specified SSL server certificate to the certificate list for
the specified HTTPS listener.
}
\details{
If the certificate in already in the certificate list, the call is
successful but the certificate is not added again.

To get the certificate list for a listener, use
DescribeListenerCertificates. To remove certificates from the
certificate list for a listener, use RemoveListenerCertificates. To
replace the default certificate for a listener, use ModifyListener.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates}{SSL Certificates}
in the \emph{Application Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$add_listener_certificates(
  ListenerArn = "string",
  Certificates = list(
    list(
      CertificateArn = "string",
      IsDefault = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
