% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_service.R
\name{route53resolver}
\alias{route53resolver}
\title{Amazon Route 53 Resolver}
\usage{
route53resolver(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Here's how you set up to query an Amazon Route 53 private hosted zone
from your network:
\enumerate{
\item Connect your network to a VPC using AWS Direct Connect or a VPN.
\item Run the following AWS CLI command to create a Resolver endpoint:

\code{create-resolver-endpoint --name \\[endpoint_name\\] --direction INBOUND --creator-request-id \\[unique_string\\] --security-group-ids \\[security_group_with_inbound_rules\\] --ip-addresses SubnetId=\\[subnet_id\\] SubnetId=\\[subnet_id_in_different_AZ\\]}

Note the resolver endpoint ID that appears in the response. You'll
use it in step 3.
\item Get the IP addresses for the Resolver endpoints:

\code{get-resolver-endpoint --resolver-endpoint-id \\[resolver_endpoint_id\\]}
\item In your network configuration, define the IP addresses that you got
in step 3 as DNS servers.

You can now query instance names in your VPCs and the names of
records in your private hosted zone.
}

You can also perform the following operations using the AWS CLI:
\itemize{
\item \code{list-resolver-endpoints}: List all endpoints. The syntax includes
options for pagination and filtering.
\item \code{update-resolver-endpoints}: Add IP addresses to an endpoint or
remove IP addresses from an endpoint.
}

To delete an endpoint, use the following AWS CLI command:

\code{delete-resolver-endpoint --resolver-endpoint-id \\[resolver_endpoint_id\\]}
}
\section{Service syntax}{
\preformatted{svc <- route53resolver(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=route53resolver_associate_resolver_endpoint_ip_address]{associate_resolver_endpoint_ip_address} \tab Adds IP addresses to an inbound or an outbound resolver endpoint \cr
\link[=route53resolver_associate_resolver_rule]{associate_resolver_rule} \tab Associates a resolver rule with a VPC \cr
\link[=route53resolver_create_resolver_endpoint]{create_resolver_endpoint} \tab Creates a resolver endpoint \cr
\link[=route53resolver_create_resolver_rule]{create_resolver_rule} \tab For DNS queries that originate in your VPCs, specifies which resolver endpoint the queries pass through, one domain name that you want to forward to your network, and the IP addresses of the DNS resolvers in your network\cr
\link[=route53resolver_delete_resolver_endpoint]{delete_resolver_endpoint} \tab Deletes a resolver endpoint \cr
\link[=route53resolver_delete_resolver_rule]{delete_resolver_rule} \tab Deletes a resolver rule \cr
\link[=route53resolver_disassociate_resolver_endpoint_ip_address]{disassociate_resolver_endpoint_ip_address} \tab Removes IP addresses from an inbound or an outbound resolver endpoint \cr
\link[=route53resolver_disassociate_resolver_rule]{disassociate_resolver_rule} \tab Removes the association between a specified resolver rule and a specified VPC \cr
\link[=route53resolver_get_resolver_endpoint]{get_resolver_endpoint} \tab Gets information about a specified resolver endpoint, such as whether it's an inbound or an outbound resolver endpoint, and the current status of the endpoint \cr
\link[=route53resolver_get_resolver_rule]{get_resolver_rule} \tab Gets information about a specified resolver rule, such as the domain name that the rule forwards DNS queries for and the ID of the outbound resolver endpoint that the rule is associated with \cr
\link[=route53resolver_get_resolver_rule_association]{get_resolver_rule_association} \tab Gets information about an association between a specified resolver rule and a VPC \cr
\link[=route53resolver_get_resolver_rule_policy]{get_resolver_rule_policy} \tab Gets information about a resolver rule policy \cr
\link[=route53resolver_list_resolver_endpoint_ip_addresses]{list_resolver_endpoint_ip_addresses} \tab Gets the IP addresses for a specified resolver endpoint \cr
\link[=route53resolver_list_resolver_endpoints]{list_resolver_endpoints} \tab Lists all the resolver endpoints that were created using the current AWS account \cr
\link[=route53resolver_list_resolver_rule_associations]{list_resolver_rule_associations} \tab Lists the associations that were created between resolver rules and VPCs using the current AWS account \cr
\link[=route53resolver_list_resolver_rules]{list_resolver_rules} \tab Lists the resolver rules that were created using the current AWS account \cr
\link[=route53resolver_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that you associated with the specified resource \cr
\link[=route53resolver_put_resolver_rule_policy]{put_resolver_rule_policy} \tab Specifies the Resolver operations and resources that you want to allow another AWS account to be able to use \cr
\link[=route53resolver_tag_resource]{tag_resource} \tab Adds one or more tags to a specified resource \cr
\link[=route53resolver_untag_resource]{untag_resource} \tab Removes one or more tags from a specified resource \cr
\link[=route53resolver_update_resolver_endpoint]{update_resolver_endpoint} \tab Updates the name of an inbound or an outbound resolver endpoint \cr
\link[=route53resolver_update_resolver_rule]{update_resolver_rule} \tab Updates settings for a specified resolver rule
}
}

\examples{
\donttest{svc <- route53resolver()
svc$associate_resolver_endpoint_ip_address(
  Foo = 123
)}

}
