# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS App Mesh
#'
#' @description
#' AWS App Mesh is a service mesh based on the Envoy proxy that makes it
#' easy to monitor and control microservices. App Mesh standardizes how
#' your microservices communicate, giving you end-to-end visibility and
#' helping to ensure high availability for your applications.
#' 
#' App Mesh gives you consistent visibility and network traffic controls
#' for every microservice in an application. You can use App Mesh with AWS
#' Fargate, Amazon ECS, Amazon EKS, Kubernetes on AWS, and Amazon EC2.
#' 
#' App Mesh supports microservice applications that use service discovery
#' naming for their components. For more information about service
#' discovery on Amazon ECS, see [Service
#' Discovery](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html)
#' in the *Amazon Elastic Container Service Developer Guide*. Kubernetes
#' `kube-dns` and `coredns` are supported. For more information, see [DNS
#' for Services and
#' Pods](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/)
#' in the Kubernetes documentation.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- appmesh(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- appmesh()
#' svc$create_mesh(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=appmesh_create_mesh]{create_mesh} \tab Creates a service mesh \cr
#'  \link[=appmesh_create_route]{create_route} \tab Creates a route that is associated with a virtual router \cr
#'  \link[=appmesh_create_virtual_node]{create_virtual_node} \tab Creates a virtual node within a service mesh \cr
#'  \link[=appmesh_create_virtual_router]{create_virtual_router} \tab Creates a virtual router within a service mesh \cr
#'  \link[=appmesh_create_virtual_service]{create_virtual_service} \tab Creates a virtual service within a service mesh \cr
#'  \link[=appmesh_delete_mesh]{delete_mesh} \tab Deletes an existing service mesh \cr
#'  \link[=appmesh_delete_route]{delete_route} \tab Deletes an existing route \cr
#'  \link[=appmesh_delete_virtual_node]{delete_virtual_node} \tab Deletes an existing virtual node \cr
#'  \link[=appmesh_delete_virtual_router]{delete_virtual_router} \tab Deletes an existing virtual router \cr
#'  \link[=appmesh_delete_virtual_service]{delete_virtual_service} \tab Deletes an existing virtual service \cr
#'  \link[=appmesh_describe_mesh]{describe_mesh} \tab Describes an existing service mesh \cr
#'  \link[=appmesh_describe_route]{describe_route} \tab Describes an existing route \cr
#'  \link[=appmesh_describe_virtual_node]{describe_virtual_node} \tab Describes an existing virtual node \cr
#'  \link[=appmesh_describe_virtual_router]{describe_virtual_router} \tab Describes an existing virtual router \cr
#'  \link[=appmesh_describe_virtual_service]{describe_virtual_service} \tab Describes an existing virtual service \cr
#'  \link[=appmesh_list_meshes]{list_meshes} \tab Returns a list of existing service meshes \cr
#'  \link[=appmesh_list_routes]{list_routes} \tab Returns a list of existing routes in a service mesh \cr
#'  \link[=appmesh_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an App Mesh resource \cr
#'  \link[=appmesh_list_virtual_nodes]{list_virtual_nodes} \tab Returns a list of existing virtual nodes \cr
#'  \link[=appmesh_list_virtual_routers]{list_virtual_routers} \tab Returns a list of existing virtual routers in a service mesh \cr
#'  \link[=appmesh_list_virtual_services]{list_virtual_services} \tab Returns a list of existing virtual services in a service mesh \cr
#'  \link[=appmesh_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
#'  \link[=appmesh_untag_resource]{untag_resource} \tab Deletes specified tags from a resource \cr
#'  \link[=appmesh_update_mesh]{update_mesh} \tab Updates an existing service mesh \cr
#'  \link[=appmesh_update_route]{update_route} \tab Updates an existing route for a specified service mesh and virtual router \cr
#'  \link[=appmesh_update_virtual_node]{update_virtual_node} \tab Updates an existing virtual node in a specified service mesh \cr
#'  \link[=appmesh_update_virtual_router]{update_virtual_router} \tab Updates an existing virtual router in a specified service mesh \cr
#'  \link[=appmesh_update_virtual_service]{update_virtual_service} \tab Updates an existing virtual service in a specified service mesh 
#' }
#'
#' @rdname appmesh
#' @export
appmesh <- function(config = list()) {
  svc <- .appmesh$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.appmesh <- list()

.appmesh$operations <- list()

.appmesh$metadata <- list(
  service_name = "appmesh",
  endpoints = list("*" = list(endpoint = "appmesh.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "appmesh.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "App Mesh",
  api_version = "2019-01-25",
  signing_name = "appmesh",
  json_version = "1.1",
  target_prefix = ""
)

.appmesh$handlers <- new_handlers("restjson", "v4")

.appmesh$service <- function(config = list()) {
  new_service(.appmesh$metadata, .appmesh$handlers, config)
}
