% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_target_group_attributes}
\alias{elbv2_modify_target_group_attributes}
\title{Modifies the specified attributes of the specified target group}
\usage{
elbv2_modify_target_group_attributes(TargetGroupArn, Attributes)
}
\arguments{
\item{TargetGroupArn}{[required] The Amazon Resource Name (ARN) of the target group.}

\item{Attributes}{[required] The attributes.}
}
\description{
Modifies the specified attributes of the specified target group.
}
\section{Request syntax}{
\preformatted{svc$modify_target_group_attributes(
  TargetGroupArn = "string",
  Attributes = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# This example sets the deregistration delay timeout to the specified
# value for the specified target group.
\donttest{svc$modify_target_group_attributes(
  Attributes = list(
    list(
      Key = "deregistration_delay.timeout_seconds",
      Value = "600"
    )
  ),
  TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targe..."
)}

}
\keyword{internal}
