% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_create_accelerator}
\alias{globalaccelerator_create_accelerator}
\title{Create an accelerator}
\usage{
globalaccelerator_create_accelerator(Name, IpAddressType, Enabled,
  IdempotencyToken)
}
\arguments{
\item{Name}{[required] The name of an accelerator. The name can have a maximum of 32
characters, must contain only alphanumeric characters or hyphens (-),
and must not begin or end with a hyphen.}

\item{IpAddressType}{The value for the address type must be IPv4.}

\item{Enabled}{Indicates whether an accelerator is enabled. The value is true or false.
The default value is true.

If the value is set to true, an accelerator cannot be deleted. If set to
false, the accelerator can be deleted.}

\item{IdempotencyToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency---that is, the uniqueness---of an accelerator.}
}
\description{
Create an accelerator. An accelerator includes one or more listeners
that process inbound connections and direct traffic to one or more
endpoint groups, each of which includes endpoints, such as Network Load
Balancers. To see an AWS CLI example of creating an accelerator, scroll
down to \strong{Example}.
}
\details{
You must specify the US-West-2 (Oregon) Region to create or update
accelerators.
}
\section{Request syntax}{
\preformatted{svc$create_accelerator(
  Name = "string",
  IpAddressType = "IPV4",
  Enabled = TRUE|FALSE,
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
