% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_deregister_instance}
\alias{servicediscovery_deregister_instance}
\title{Deletes the Amazon Route 53 DNS records and health check, if any, that
AWS Cloud Map created for the specified instance}
\usage{
servicediscovery_deregister_instance(ServiceId, InstanceId)
}
\arguments{
\item{ServiceId}{[required] The ID of the service that the instance is associated with.}

\item{InstanceId}{[required] The value that you specified for \code{Id} in the
\href{https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html}{RegisterInstance}
request.}
}
\description{
Deletes the Amazon Route 53 DNS records and health check, if any, that
AWS Cloud Map created for the specified instance.
}
\section{Request syntax}{
\preformatted{svc$deregister_instance(
  ServiceId = "string",
  InstanceId = "string"
)
}
}

\examples{
\dontrun{
# Example: Deregister a service instance
svc$deregister_instance(
  InstanceId = "myservice-53",
  ServiceId = "srv-p5zdwlg5uvvzjita"
)
}

}
\keyword{internal}
