% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_conflicting_aliases}
\alias{cloudfront_list_conflicting_aliases}
\title{Gets a list of aliases (also called CNAMEs or alternate domain names)
that conflict or overlap with the provided alias, and the associated
CloudFront distributions and Amazon Web Services accounts for each
conflicting alias}
\usage{
cloudfront_list_conflicting_aliases(
  DistributionId,
  Alias,
  Marker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{DistributionId}{[required] The ID of a distribution in your account that has an attached SSL/TLS
certificate that includes the provided alias.}

\item{Alias}{[required] The alias (also called a CNAME) to search for conflicting aliases.}

\item{Marker}{Use this field when paginating results to indicate where to begin in the
list of conflicting aliases. The response includes conflicting aliases
in the list that occur after the marker. To get the next page of the
list, set this field’s value to the value of \code{NextMarker} from the
current page’s response.}

\item{MaxItems}{The maximum number of conflicting aliases that you want in the response.}
}
\description{
Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias. In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don’t own.

See \url{https://paws-r.github.io/docs/cloudfront/list_conflicting_aliases.html} for full documentation.
}
\keyword{internal}
