% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_associate_resolver_rule}
\alias{route53resolver_associate_resolver_rule}
\title{Associates a Resolver rule with a VPC}
\usage{
route53resolver_associate_resolver_rule(ResolverRuleId, Name = NULL, VPCId)
}
\arguments{
\item{ResolverRuleId}{[required] The ID of the Resolver rule that you want to associate with the VPC. To
list the existing Resolver rules, use
\code{\link[=route53resolver_list_resolver_rules]{list_resolver_rules}}.}

\item{Name}{A name for the association that you're creating between a Resolver rule
and a VPC.}

\item{VPCId}{[required] The ID of the VPC that you want to associate the Resolver rule with.}
}
\description{
Associates a Resolver rule with a VPC. When you associate a rule with a VPC, Resolver forwards all DNS queries for the domain name that is specified in the rule and that originate in the VPC. The queries are forwarded to the IP addresses for the DNS resolvers that are specified in the rule. For more information about rules, see \code{\link[=route53resolver_create_resolver_rule]{create_resolver_rule}}.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_associate_resolver_rule/} for full documentation.
}
\keyword{internal}
