# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Route 53 Profiles
#'
#' @description
#' With Amazon Route 53 Profiles you can share Route 53 configurations with
#' VPCs and AWS accounts
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- route53profiles(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- route53profiles()
#' svc$associate_profile(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=route53profiles_associate_profile]{associate_profile} \tab Associates a Route 53 Profiles profile with a VPC\cr
#'  \link[=route53profiles_associate_resource_to_profile]{associate_resource_to_profile} \tab Associates a DNS reource configuration to a Route 53 Profile\cr
#'  \link[=route53profiles_create_profile]{create_profile} \tab Creates an empty Route 53 Profile\cr
#'  \link[=route53profiles_delete_profile]{delete_profile} \tab Deletes the specified Route 53 Profile\cr
#'  \link[=route53profiles_disassociate_profile]{disassociate_profile} \tab Dissociates a specified Route 53 Profile from the specified VPC\cr
#'  \link[=route53profiles_disassociate_resource_from_profile]{disassociate_resource_from_profile} \tab Dissoaciated a specified resource, from the Route 53 Profile\cr
#'  \link[=route53profiles_get_profile]{get_profile} \tab Returns information about a specified Route 53 Profile, such as whether whether the Profile is shared, and the current status of the Profile\cr
#'  \link[=route53profiles_get_profile_association]{get_profile_association} \tab Retrieves a Route 53 Profile association for a VPC\cr
#'  \link[=route53profiles_get_profile_resource_association]{get_profile_resource_association} \tab Returns information about a specified Route 53 Profile resource association\cr
#'  \link[=route53profiles_list_profile_associations]{list_profile_associations} \tab Lists all the VPCs that the specified Route 53 Profile is associated with\cr
#'  \link[=route53profiles_list_profile_resource_associations]{list_profile_resource_associations} \tab Lists all the resource associations for the specified Route 53 Profile\cr
#'  \link[=route53profiles_list_profiles]{list_profiles} \tab Lists all the Route 53 Profiles associated with your Amazon Web Services account\cr
#'  \link[=route53profiles_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that you associated with the specified resource\cr
#'  \link[=route53profiles_tag_resource]{tag_resource} \tab Adds one or more tags to a specified resource\cr
#'  \link[=route53profiles_untag_resource]{untag_resource} \tab Removes one or more tags from a specified resource\cr
#'  \link[=route53profiles_update_profile_resource_association]{update_profile_resource_association} \tab Updates the specified Route 53 Profile resourse association
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname route53profiles
#' @export
route53profiles <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .route53profiles$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.route53profiles <- list()

.route53profiles$operations <- list()

.route53profiles$metadata <- list(
  service_name = "route53profiles",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "route53profiles.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Route53Profiles",
  api_version = "2018-05-10",
  signing_name = "route53profiles",
  json_version = "1.1",
  target_prefix = ""
)

.route53profiles$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.route53profiles$metadata, handlers, config, op)
}
