% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_associate_firewall_rule_group}
\alias{route53resolver_associate_firewall_rule_group}
\title{Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for
the VPC}
\usage{
route53resolver_associate_firewall_rule_group(
  CreatorRequestId,
  FirewallRuleGroupId,
  VpcId,
  Priority,
  Name,
  MutationProtection = NULL,
  Tags = NULL
)
}
\arguments{
\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows failed
requests to be retried without the risk of running the operation twice.
\code{CreatorRequestId} can be any unique string, for example, a date/time
stamp.}

\item{FirewallRuleGroupId}{[required] The unique identifier of the firewall rule group.}

\item{VpcId}{[required] The unique identifier of the VPC that you want to associate with the
rule group.}

\item{Priority}{[required] The setting that determines the processing order of the rule group among
the rule groups that you associate with the specified VPC. DNS Firewall
filters VPC traffic starting from the rule group with the lowest numeric
priority setting.

You must specify a unique priority for each rule group that you
associate with a single VPC. To make it easier to insert rule groups
later, leave space between the numbers, for example, use 101, 200, and
so on. You can change the priority setting for a rule group association
after you create it.

The allowed values for \code{Priority} are between 100 and 9900.}

\item{Name}{[required] A name that lets you identify the association, to manage and use it.}

\item{MutationProtection}{If enabled, this setting disallows modification or removal of the
association, to help prevent against accidentally altering DNS firewall
protections. When you create the association, the default setting is
\code{DISABLED}.}

\item{Tags}{A list of the tag keys and values that you want to associate with the
rule group association.}
}
\description{
Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_associate_firewall_rule_group/} for full documentation.
}
\keyword{internal}
