% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_role_with_web_identity}
\alias{sts_assume_role_with_web_identity}
\title{Returns a set of temporary security credentials for users who have been
authenticated in a mobile or web application with a web identity
provider, such as Amazon Cognito, Login with Amazon, Facebook, Google,
or any OpenID Connect-compatible identity provider}
\usage{
sts_assume_role_with_web_identity(RoleArn, RoleSessionName,
  WebIdentityToken, ProviderId, Policy, DurationSeconds)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role that the caller is assuming.}

\item{RoleSessionName}{[required] An identifier for the assumed role session. Typically, you pass the name
or identifier that is associated with the user who is using your
application. That way, the temporary security credentials that your
application will use are associated with that user. This session name is
included as part of the ARN and assumed role ID in the \code{AssumedRoleUser}
response element.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{WebIdentityToken}{[required] The OAuth 2.0 access token or OpenID Connect ID token that is provided
by the identity provider. Your application must get this token by
authenticating the user who is using your application with a web
identity provider before the application makes an
\code{AssumeRoleWithWebIdentity} call.}

\item{ProviderId}{The fully qualified host component of the domain name of the identity
provider.

Specify this value only for OAuth 2.0 access tokens. Currently
\code{www.amazon.com} and \code{graph.facebook.com} are the only supported
identity providers for OAuth 2.0 access tokens. Do not include URL
schemes and port numbers.

Do not specify this value for OpenID Connect ID tokens.}

\item{Policy}{An IAM policy in JSON format.

The policy parameter is optional. If you pass a policy, the temporary
security credentials that are returned by the operation have the
permissions that are allowed by both the access policy of the role that
is being assumed, \emph{\strong{and}} the policy that you pass. This gives you a
way to further restrict the permissions for the resulting temporary
security credentials. You cannot use the passed policy to grant
permissions that are in excess of those allowed by the access policy of
the role that is being assumed. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html}{Permissions for AssumeRoleWithWebIdentity}
in the \emph{IAM User Guide}.

The format for this parameter, as described by its regex pattern, is a
string of characters up to 2048 characters in length. The characters can
be any ASCII character from the space character to the end of the valid
character list (\code{U+0020}-\code{U+00FF}). It can also include the tab (\code{U+0009}),
linefeed (\code{U+000A}), and carriage return (\code{U+000D}) characters.

The policy plain text must be 2048 bytes or shorter. However, an
internal conversion compresses it into a packed binary format with a
separate limit. The PackedPolicySize response element indicates by
percentage how close to the upper size limit the policy is, with 100\%
equaling the maximum allowed size.}

\item{DurationSeconds}{The duration, in seconds, of the role session. The value can range from
900 seconds (15 minutes) up to the maximum session duration setting for
the role. This setting can have a value from 1 hour to 12 hours. If you
specify a value higher than this setting, the operation fails. For
example, if you specify a session duration of 12 hours, but your
administrator set the maximum session duration to 6 hours, your
operation fails. To learn how to view the maximum value for your role,
see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}.

By default, the value is set to 3600 seconds.

The \code{DurationSeconds} parameter is separate from the duration of a
console session that you might request using the returned credentials.
The request to the federation endpoint for a console sign-in token takes
a \code{SessionDuration} parameter that specifies the maximum length of the
console session. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html}{Creating a URL that Enables Federated Users to Access the AWS Management Console}
in the \emph{IAM User Guide}.}
}
\description{
Returns a set of temporary security credentials for users who have been
authenticated in a mobile or web application with a web identity
provider, such as Amazon Cognito, Login with Amazon, Facebook, Google,
or any OpenID Connect-compatible identity provider.
}
\details{
For mobile applications, we recommend that you use Amazon Cognito. You
can use Amazon Cognito with the \href{http://aws.amazon.com/sdkforios/}{AWS SDK for iOS} and the \href{http://aws.amazon.com/sdkforandroid/}{AWS SDK for Android} to uniquely identify a
user and supply the user with a consistent identity throughout the
lifetime of an application.

To learn more about Amazon Cognito, see \href{http://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-auth.html#d0e840}{Amazon Cognito Overview}
in the \emph{AWS SDK for Android Developer Guide} guide and \href{http://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-auth.html#d0e664}{Amazon Cognito Overview}
in the \emph{AWS SDK for iOS Developer Guide}.

Calling \code{AssumeRoleWithWebIdentity} does not require the use of AWS
security credentials. Therefore, you can distribute an application (for
example, on mobile devices) that requests temporary security credentials
without including long-term AWS credentials in the application, and
without deploying server-based proxy services that use long-term AWS
credentials. Instead, the identity of the caller is validated by using a
token from the web identity provider. For a comparison of
\code{AssumeRoleWithWebIdentity} with the other APIs that produce temporary
credentials, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials}
and \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the AWS STS APIs}
in the \emph{IAM User Guide}.

The temporary security credentials returned by this API consist of an
access key ID, a secret access key, and a security token. Applications
can use these temporary security credentials to sign calls to AWS
service APIs.

By default, the temporary security credentials created by
\code{AssumeRoleWithWebIdentity} last for one hour. However, you can use the
optional \code{DurationSeconds} parameter to specify the duration of your
session. You can provide a value from 900 seconds (15 minutes) up to the
maximum session duration setting for the role. This setting can have a
value from 1 hour to 12 hours. To learn how to view the maximum value
for your role, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}. The maximum session duration limit applies when
you use the \code{AssumeRole*} API operations or the \code{assume-role*} CLI
operations but does not apply when you use those operations to create a
console URL. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html}{Using IAM Roles}
in the \emph{IAM User Guide}.

The temporary security credentials created by
\code{AssumeRoleWithWebIdentity} can be used to make API calls to any AWS
service with the following exception: you cannot call the STS service's
\code{GetFederationToken} or \code{GetSessionToken} APIs.

Optionally, you can pass an IAM access policy to this operation. If you
choose not to pass a policy, the temporary security credentials that are
returned by the operation have the permissions that are defined in the
access policy of the role that is being assumed. If you pass a policy to
this operation, the temporary security credentials that are returned by
the operation have the permissions that are allowed by both the access
policy of the role that is being assumed, \emph{\strong{and}} the policy that you
pass. This gives you a way to further restrict the permissions for the
resulting temporary security credentials. You cannot use the passed
policy to grant permissions that are in excess of those allowed by the
access policy of the role that is being assumed. For more information,
see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html}{Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity}
in the \emph{IAM User Guide}.

Before your application can call \code{AssumeRoleWithWebIdentity}, you must
have an identity token from a supported identity provider and create a
role that the application can assume. The role that your application
assumes must trust the identity provider that is associated with the
identity token. In other words, the identity provider must be specified
in the role's trust policy.

Calling \code{AssumeRoleWithWebIdentity} can result in an entry in your AWS
CloudTrail logs. The entry includes the
\href{http://openid.net/specs/openid-connect-core-1_0.html#Claims}{Subject}
of the provided Web Identity Token. We recommend that you avoid using
any personally identifiable information (PII) in this field. For
example, you could instead use a GUID or a pairwise identifier, as
\href{http://openid.net/specs/openid-connect-core-1_0.html#SubjectIDTypes}{suggested in the OIDC specification}.

For more information about how to use web identity federation and the
\code{AssumeRoleWithWebIdentity} API, see the following resources:
\itemize{
\item \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc_manual.html}{Using Web Identity Federation APIs for Mobile Apps}
and \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity}{Federation Through a Web-based Identity Provider}.
\item \href{https://web-identity-federation-playground.s3.amazonaws.com/index.html}{Web Identity Federation Playground}.
This interactive website lets you walk through the process of
authenticating via Login with Amazon, Facebook, or Google, getting
temporary security credentials, and then using those credentials to
make a request to AWS.
\item \href{http://aws.amazon.com/sdkforios/}{AWS SDK for iOS} and \href{http://aws.amazon.com/sdkforandroid/}{AWS SDK for Android}. These toolkits
contain sample apps that show how to invoke the identity providers,
and then how to use the information from these providers to get and
use temporary security credentials.
\item \href{http://aws.amazon.com/articles/web-identity-federation-with-mobile-applications}{Web Identity Federation with Mobile Applications}.
This article discusses web identity federation and shows an example
of how to use web identity federation to get access to content in
Amazon S3.
}
}
\section{Request syntax}{
\preformatted{svc$assume_role_with_web_identity(
  RoleArn = "string",
  RoleSessionName = "string",
  WebIdentityToken = "string",
  ProviderId = "string",
  Policy = "string",
  DurationSeconds = 123
)
}
}

\examples{
# 
\donttest{svc$assume_role_with_web_identity(
  DurationSeconds = 3600L,
  ProviderId = "www.amazon.com",
  RoleArn = "arn:aws:iam::123456789012:role/FederatedWebIdentityRole",
  RoleSessionName = "app1",
  WebIdentityToken = "Atza\%7CIQEBLjAsAhRFiXuWpUXuRvQ9PZL3GMFcYevydwIUFAHZwXZXXXXXXXXJnrulxKD..."
)}

}
\keyword{internal}
