% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_put_policy}
\alias{acmpca_put_policy}
\title{Attaches a resource-based policy to a private CA}
\usage{
acmpca_put_policy(ResourceArn, Policy)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Number (ARN) of the private CA to associate with the
policy. The ARN of the CA can be found by calling the
\href{https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html}{ListCertificateAuthorities}
action.}

\item{Policy}{[required] The path and filename of a JSON-formatted IAM policy to attach to the
specified private CA resource. If this policy does not contain all
required statements or if it includes any statement that is not allowed,
the \code{PutPolicy} action returns an \code{InvalidPolicyException}. For
information about IAM policy and statement structure, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json}{Overview of JSON Policies}.}
}
\description{
Attaches a resource-based policy to a private CA.

A policy can also be applied by sharing a private CA through AWS
Resource Access Manager (RAM). For more information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html}{Attach a Policy for Cross-Account Access}.

The policy can be displayed with
\href{https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html}{GetPolicy}
and removed with
\href{https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html}{DeletePolicy}.

\strong{About Policies}
\itemize{
\item A policy grants access on a private CA to an AWS customer account,
to AWS Organizations, or to an AWS Organizations unit. Policies are
under the control of a CA administrator. For more information, see
\href{https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html}{Using a Resource Based Policy with ACM Private CA}.
\item A policy permits a user of AWS Certificate Manager (ACM) to issue
ACM certificates signed by a CA in another account.
\item For ACM to manage automatic renewal of these certificates, the ACM
user must configure a Service Linked Role (SLR). The SLR allows the
ACM service to assume the identity of the user, subject to
confirmation against the ACM Private CA policy. For more
information, see \href{https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html}{Using a Service Linked Role with ACM}.
\item Updates made in AWS Resource Manager (RAM) are reflected in
policies. For more information, see \href{https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html}{Attach a Policy for Cross-Account Access}.
}
}
\section{Request syntax}{
\preformatted{svc$put_policy(
  ResourceArn = "string",
  Policy = "string"
)
}
}

\keyword{internal}
