% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_create_identity_pool}
\alias{cognitoidentity_create_identity_pool}
\title{Creates a new identity pool}
\usage{
cognitoidentity_create_identity_pool(IdentityPoolName,
  AllowUnauthenticatedIdentities, AllowClassicFlow,
  SupportedLoginProviders, DeveloperProviderName,
  OpenIdConnectProviderARNs, CognitoIdentityProviders, SamlProviderARNs,
  IdentityPoolTags)
}
\arguments{
\item{IdentityPoolName}{[required] A string that you provide.}

\item{AllowUnauthenticatedIdentities}{[required] TRUE if the identity pool supports unauthenticated logins.}

\item{AllowClassicFlow}{Enables or disables the Basic (Classic) authentication flow. For more
information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html}{Identity Pools (Federated Identities) Authentication Flow}
in the \emph{Amazon Cognito Developer Guide}.}

\item{SupportedLoginProviders}{Optional key:value pairs mapping provider names to provider app IDs.}

\item{DeveloperProviderName}{The "domain" by which Cognito will refer to your users. This name acts
as a placeholder that allows your backend and the Cognito service to
communicate about the developer provider. For the
\code{DeveloperProviderName}, you can use letters as well as period (\code{.}),
underscore (\verb{_}), and dash (\code{-}).

Once you have set a developer provider name, you cannot change it.
Please take care in setting this parameter.}

\item{OpenIdConnectProviderARNs}{A list of OpendID Connect provider ARNs.}

\item{CognitoIdentityProviders}{An array of Amazon Cognito user pools and their client IDs.}

\item{SamlProviderARNs}{An array of Amazon Resource Names (ARNs) of the SAML provider for your
identity pool.}

\item{IdentityPoolTags}{Tags to assign to the identity pool. A tag is a label that you can apply
to identity pools to categorize and manage them in different ways, such
as by purpose, owner, environment, or other criteria.}
}
\description{
Creates a new identity pool. The identity pool is a store of user
identity information that is specific to your AWS account. The keys for
\code{SupportedLoginProviders} are as follows:
\itemize{
\item Facebook: \code{graph.facebook.com}
\item Google: \code{accounts.google.com}
\item Amazon: \code{www.amazon.com}
\item Twitter: \code{api.twitter.com}
\item Digits: \code{www.digits.com}
}

You must use AWS Developer credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$create_identity_pool(
  IdentityPoolName = "string",
  AllowUnauthenticatedIdentities = TRUE|FALSE,
  AllowClassicFlow = TRUE|FALSE,
  SupportedLoginProviders = list(
    "string"
  ),
  DeveloperProviderName = "string",
  OpenIdConnectProviderARNs = list(
    "string"
  ),
  CognitoIdentityProviders = list(
    list(
      ProviderName = "string",
      ClientId = "string",
      ServerSideTokenCheck = TRUE|FALSE
    )
  ),
  SamlProviderARNs = list(
    "string"
  ),
  IdentityPoolTags = list(
    "string"
  )
)
}
}

\keyword{internal}
