% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_group}
\alias{cognitoidentityprovider_update_group}
\title{Updates the specified group with the specified attributes}
\usage{
cognitoidentityprovider_update_group(GroupName, UserPoolId, Description,
  RoleArn, Precedence)
}
\arguments{
\item{GroupName}{[required] The name of the group.}

\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{Description}{A string containing the new description of the group.}

\item{RoleArn}{The new role ARN for the group. This is used for setting the
\code{cognito:roles} and \code{cognito:preferred_role} claims in the token.}

\item{Precedence}{The new precedence value for the group. For more information about this
parameter, see
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html}{CreateGroup}.}
}
\description{
Updates the specified group with the specified attributes.

Calling this action requires developer credentials.

If you don't provide a value for an attribute, it will be set to the
default value.
}
\section{Request syntax}{
\preformatted{svc$update_group(
  GroupName = "string",
  UserPoolId = "string",
  Description = "string",
  RoleArn = "string",
  Precedence = 123
)
}
}

\keyword{internal}
