% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_generate_organizations_access_report}
\alias{iam_generate_organizations_access_report}
\title{Generates a report for service last accessed data for AWS Organizations}
\usage{
iam_generate_organizations_access_report(EntityPath,
  OrganizationsPolicyId)
}
\arguments{
\item{EntityPath}{[required] The path of the AWS Organizations entity (root, OU, or account). You can
build an entity path using the known structure of your organization. For
example, assume that your account ID is \code{123456789012} and its parent OU
ID is \code{ou-rge0-awsabcde}. The organization root ID is
\code{r-f6g7h8i9j0example} and your organization ID is \code{o-a1b2c3d4e5}. Your
entity path is
\code{o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012}.}

\item{OrganizationsPolicyId}{The identifier of the AWS Organizations service control policy (SCP).
This parameter is optional.

This ID is used to generate information about when an account principal
that is limited by the SCP attempted to access an AWS service.}
}
\description{
Generates a report for service last accessed data for AWS Organizations.
You can generate a report for any entities (organization root,
organizational unit, or account) or policies in your organization.

To call this operation, you must be signed in using your AWS
Organizations master account credentials. You can use your long-term IAM
user or root user credentials, or temporary credentials from assuming an
IAM role. SCPs must be enabled for your organization root. You must have
the required IAM and AWS Organizations permissions. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html}{Refining Permissions Using Service Last Accessed Data}
in the \emph{IAM User Guide}.

You can generate a service last accessed data report for entities by
specifying only the entity's path. This data includes a list of services
that are allowed by any service control policies (SCPs) that apply to
the entity.

You can generate a service last accessed data report for a policy by
specifying an entity's path and an optional AWS Organizations policy ID.
This data includes a list of services that are allowed by the specified
SCP.

For each service in both report types, the data includes the most recent
account activity that the policy allows to account principals in the
entity or the entity's children. For important information about the
data, reporting period, permissions required, troubleshooting, and
supported Regions see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html}{Reducing Permissions Using Service Last Accessed Data}
in the \emph{IAM User Guide}.

The data includes all attempts to access AWS, not just the successful
ones. This includes all attempts that were made using the AWS Management
Console, the AWS API through any of the SDKs, or any of the command line
tools. An unexpected entry in the service last accessed data does not
mean that an account has been compromised, because the request might
have been denied. Refer to your CloudTrail logs as the authoritative
source for information about all API calls and whether they were
successful or denied access. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html}{Logging IAM Events with CloudTrail}
in the \emph{IAM User Guide}.

This operation returns a \code{JobId}. Use this parameter in the
\verb{<a>GetOrganizationsAccessReport</a>} operation to check the status of
the report generation. To check the status of this request, use the
\code{JobId} parameter in the \verb{<a>GetOrganizationsAccessReport</a>}
operation and test the \code{JobStatus} response parameter. When the job is
complete, you can retrieve the report.

To generate a service last accessed data report for entities, specify an
entity path without specifying the optional AWS Organizations policy ID.
The type of entity that you specify determines the data returned in the
report.
\itemize{
\item \strong{Root} – When you specify the organizations root as the entity,
the resulting report lists all of the services allowed by SCPs that
are attached to your root. For each service, the report includes
data for all accounts in your organization except the master
account, because the master account is not limited by SCPs.
\item \strong{OU} – When you specify an organizational unit (OU) as the entity,
the resulting report lists all of the services allowed by SCPs that
are attached to the OU and its parents. For each service, the report
includes data for all accounts in the OU or its children. This data
excludes the master account, because the master account is not
limited by SCPs.
\item \strong{Master account} – When you specify the master account, the
resulting report lists all AWS services, because the master account
is not limited by SCPs. For each service, the report includes data
for only the master account.
\item \strong{Account} – When you specify another account as the entity, the
resulting report lists all of the services allowed by SCPs that are
attached to the account and its parents. For each service, the
report includes data for only the specified account.
}

To generate a service last accessed data report for policies, specify an
entity path and the optional AWS Organizations policy ID. The type of
entity that you specify determines the data returned for each service.
\itemize{
\item \strong{Root} – When you specify the root entity and a policy ID, the
resulting report lists all of the services that are allowed by the
specified SCP. For each service, the report includes data for all
accounts in your organization to which the SCP applies. This data
excludes the master account, because the master account is not
limited by SCPs. If the SCP is not attached to any entities in the
organization, then the report will return a list of services with no
data.
\item \strong{OU} – When you specify an OU entity and a policy ID, the
resulting report lists all of the services that are allowed by the
specified SCP. For each service, the report includes data for all
accounts in the OU or its children to which the SCP applies. This
means that other accounts outside the OU that are affected by the
SCP might not be included in the data. This data excludes the master
account, because the master account is not limited by SCPs. If the
SCP is not attached to the OU or one of its children, the report
will return a list of services with no data.
\item \strong{Master account} – When you specify the master account, the
resulting report lists all AWS services, because the master account
is not limited by SCPs. If you specify a policy ID in the CLI or
API, the policy is ignored. For each service, the report includes
data for only the master account.
\item \strong{Account} – When you specify another account entity and a policy
ID, the resulting report lists all of the services that are allowed
by the specified SCP. For each service, the report includes data for
only the specified account. This means that other accounts in the
organization that are affected by the SCP might not be included in
the data. If the SCP is not attached to the account, the report will
return a list of services with no data.
}

Service last accessed data does not use other policy types when
determining whether a principal could access a service. These other
policy types include identity-based policies, resource-based policies,
access control lists, IAM permissions boundaries, and STS assume role
policies. It only applies SCP logic. For more about the evaluation of
policy types, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics}{Evaluating Policies}
in the \emph{IAM User Guide}.

For more information about service last accessed data, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html}{Reducing Policy Scope by Viewing User Activity}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$generate_organizations_access_report(
  EntityPath = "string",
  OrganizationsPolicyId = "string"
)
}
}

\examples{
\dontrun{
# The following operation generates a report for the organizational unit
# ou-rge0-awexample
svc$generate_organizations_access_report(
  EntityPath = "o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-1a2b3c-k9l8m7n6o5example"
)
}

}
\keyword{internal}
