% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_update_key_description}
\alias{kms_update_key_description}
\title{Updates the description of a customer master key (CMK)}
\usage{
kms_update_key_description(KeyId, Description)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{Description}{[required] New description for the CMK.}
}
\description{
Updates the description of a customer master key (CMK). To see the
description of a CMK, use DescribeKey.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:UpdateKeyDescription}
(key policy)

\strong{Related operations}
\itemize{
\item CreateKey
\item DescribeKey
}
}
\section{Request syntax}{
\preformatted{svc$update_key_description(
  KeyId = "string",
  Description = "string"
)
}
}

\examples{
\dontrun{
# The following example updates the description of the specified CMK.
svc$update_key_description(
  Description = "Example description that indicates the intended use of this CMK.",
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
