% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_describe_certificate_authority}
\alias{acmpca_describe_certificate_authority}
\title{Lists information about your private certificate authority (CA) or one
that has been shared with you}
\usage{
acmpca_describe_certificate_authority(CertificateAuthorityArn)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}.
This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }.}
}
\value{
A list with the following syntax:\preformatted{list(
  CertificateAuthority = list(
    Arn = "string",
    OwnerAccount = "string",
    CreatedAt = as.POSIXct(
      "2015-01-01"
    ),
    LastStateChangeAt = as.POSIXct(
      "2015-01-01"
    ),
    Type = "ROOT"|"SUBORDINATE",
    Serial = "string",
    Status = "CREATING"|"PENDING_CERTIFICATE"|"ACTIVE"|"DELETED"|"DISABLED"|"EXPIRED"|"FAILED",
    NotBefore = as.POSIXct(
      "2015-01-01"
    ),
    NotAfter = as.POSIXct(
      "2015-01-01"
    ),
    FailureReason = "REQUEST_TIMED_OUT"|"UNSUPPORTED_ALGORITHM"|"OTHER",
    CertificateAuthorityConfiguration = list(
      KeyAlgorithm = "RSA_2048"|"RSA_4096"|"EC_prime256v1"|"EC_secp384r1",
      SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
      Subject = list(
        Country = "string",
        Organization = "string",
        OrganizationalUnit = "string",
        DistinguishedNameQualifier = "string",
        State = "string",
        CommonName = "string",
        SerialNumber = "string",
        Locality = "string",
        Title = "string",
        Surname = "string",
        GivenName = "string",
        Initials = "string",
        Pseudonym = "string",
        GenerationQualifier = "string"
      ),
      CsrExtensions = list(
        KeyUsage = list(
          DigitalSignature = TRUE|FALSE,
          NonRepudiation = TRUE|FALSE,
          KeyEncipherment = TRUE|FALSE,
          DataEncipherment = TRUE|FALSE,
          KeyAgreement = TRUE|FALSE,
          KeyCertSign = TRUE|FALSE,
          CRLSign = TRUE|FALSE,
          EncipherOnly = TRUE|FALSE,
          DecipherOnly = TRUE|FALSE
        ),
        SubjectInformationAccess = list(
          list(
            AccessMethod = list(
              CustomObjectIdentifier = "string",
              AccessMethodType = "CA_REPOSITORY"|"RESOURCE_PKI_MANIFEST"|"RESOURCE_PKI_NOTIFY"
            ),
            AccessLocation = list(
              OtherName = list(
                TypeId = "string",
                Value = "string"
              ),
              Rfc822Name = "string",
              DnsName = "string",
              DirectoryName = list(
                Country = "string",
                Organization = "string",
                OrganizationalUnit = "string",
                DistinguishedNameQualifier = "string",
                State = "string",
                CommonName = "string",
                SerialNumber = "string",
                Locality = "string",
                Title = "string",
                Surname = "string",
                GivenName = "string",
                Initials = "string",
                Pseudonym = "string",
                GenerationQualifier = "string"
              ),
              EdiPartyName = list(
                PartyName = "string",
                NameAssigner = "string"
              ),
              UniformResourceIdentifier = "string",
              IpAddress = "string",
              RegisteredId = "string"
            )
          )
        )
      )
    ),
    RevocationConfiguration = list(
      CrlConfiguration = list(
        Enabled = TRUE|FALSE,
        ExpirationInDays = 123,
        CustomCname = "string",
        S3BucketName = "string"
      )
    ),
    RestorableUntil = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Lists information about your private certificate authority (CA) or one
that has been shared with you. You specify the private CA on input by
its ARN (Amazon Resource Name). The output contains the status of your
CA. This can be any of the following:
\itemize{
\item \code{CREATING} - ACM Private CA is creating your private certificate
authority.
\item \code{PENDING_CERTIFICATE} - The certificate is pending. You must use
your ACM Private CA-hosted or on-premises root or subordinate CA to
sign your private CA CSR and then import it into PCA.
\item \code{ACTIVE} - Your private CA is active.
\item \code{DISABLED} - Your private CA has been disabled.
\item \code{EXPIRED} - Your private CA certificate has expired.
\item \code{FAILED} - Your private CA has failed. Your CA can fail because of
problems such a network outage or backend AWS failure or other
errors. A failed CA can never return to the pending state. You must
create a new CA.
\item \code{DELETED} - Your private CA is within the restoration period, after
which it is permanently deleted. The length of time remaining in the
CA's restoration period is also included in this action's output.
}
}
\section{Request syntax}{
\preformatted{svc$describe_certificate_authority(
  CertificateAuthorityArn = "string"
)
}
}

\keyword{internal}
