% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_add_facet_to_object}
\alias{clouddirectory_add_facet_to_object}
\title{Adds a new Facet to an object}
\usage{
clouddirectory_add_facet_to_object(DirectoryArn, SchemaFacet,
  ObjectAttributeList, ObjectReference)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the object resides. For more information, see arns.}

\item{SchemaFacet}{[required] Identifiers for the facet that you are adding to the object. See
SchemaFacet for details.}

\item{ObjectAttributeList}{Attributes on the facet that you are adding to the object.}

\item{ObjectReference}{[required] A reference to the object you are adding the specified facet to.}
}
\value{
An empty list.
}
\description{
Adds a new Facet to an object. An object can have more than one facet
applied on it.
}
\section{Request syntax}{
\preformatted{svc$add_facet_to_object(
  DirectoryArn = "string",
  SchemaFacet = list(
    SchemaArn = "string",
    FacetName = "string"
  ),
  ObjectAttributeList = list(
    list(
      Key = list(
        SchemaArn = "string",
        FacetName = "string",
        Name = "string"
      ),
      Value = list(
        StringValue = "string",
        BinaryValue = raw,
        BooleanValue = TRUE|FALSE,
        NumberValue = "string",
        DatetimeValue = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  ),
  ObjectReference = list(
    Selector = "string"
  )
)
}
}

\keyword{internal}
