% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_apply_schema}
\alias{clouddirectory_apply_schema}
\title{Copies the input published schema, at the specified version, into the
Directory with the same name and version as that of the published schema}
\usage{
clouddirectory_apply_schema(PublishedSchemaArn, DirectoryArn)
}
\arguments{
\item{PublishedSchemaArn}{[required] Published schema Amazon Resource Name (ARN) that needs to be copied. For
more information, see arns.}

\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
into which the schema is copied. For more information, see arns.}
}
\value{
A list with the following syntax:\preformatted{list(
  AppliedSchemaArn = "string",
  DirectoryArn = "string"
)
}
}
\description{
Copies the input published schema, at the specified version, into the
Directory with the same name and version as that of the published
schema.
}
\section{Request syntax}{
\preformatted{svc$apply_schema(
  PublishedSchemaArn = "string",
  DirectoryArn = "string"
)
}
}

\keyword{internal}
