% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_create_facet}
\alias{clouddirectory_create_facet}
\title{Creates a new Facet in a schema}
\usage{
clouddirectory_create_facet(SchemaArn, Name, Attributes, ObjectType,
  FacetStyle)
}
\arguments{
\item{SchemaArn}{[required] The schema ARN in which the new Facet will be created. For more
information, see arns.}

\item{Name}{[required] The name of the Facet, which is unique for a given schema.}

\item{Attributes}{The attributes that are associated with the Facet.}

\item{ObjectType}{Specifies whether a given object created from this facet is of type
node, leaf node, policy or index.
\itemize{
\item Node: Can have multiple children but one parent.
\item Leaf node: Cannot have children but can have multiple parents.
\item Policy: Allows you to store a policy document and policy type. For
more information, see
\href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies}{Policies}.
\item Index: Can be created with the Index API.
}}

\item{FacetStyle}{There are two different styles that you can define on any given facet,
\code{Static} and \code{Dynamic}. For static facets, all attributes must be
defined in the schema. For dynamic facets, attributes can be defined
during data plane operations.}
}
\value{
An empty list.
}
\description{
Creates a new Facet in a schema. Facet creation is allowed only in
development or applied schemas.
}
\section{Request syntax}{
\preformatted{svc$create_facet(
  SchemaArn = "string",
  Name = "string",
  Attributes = list(
    list(
      Name = "string",
      AttributeDefinition = list(
        Type = "STRING"|"BINARY"|"BOOLEAN"|"NUMBER"|"DATETIME"|"VARIANT",
        DefaultValue = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        ),
        IsImmutable = TRUE|FALSE,
        Rules = list(
          list(
            Type = "BINARY_LENGTH"|"NUMBER_COMPARISON"|"STRING_FROM_SET"|"STRING_LENGTH",
            Parameters = list(
              "string"
            )
          )
        )
      ),
      AttributeReference = list(
        TargetFacetName = "string",
        TargetAttributeName = "string"
      ),
      RequiredBehavior = "REQUIRED_ALWAYS"|"NOT_REQUIRED"
    )
  ),
  ObjectType = "NODE"|"LEAF_NODE"|"POLICY"|"INDEX",
  FacetStyle = "STATIC"|"DYNAMIC"
)
}
}

\keyword{internal}
