% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_describe_backups}
\alias{cloudhsmv2_describe_backups}
\title{Gets information about backups of AWS CloudHSM clusters}
\usage{
cloudhsmv2_describe_backups(NextToken, MaxResults, Filters,
  SortAscending)
}
\arguments{
\item{NextToken}{The \code{NextToken} value that you received in the previous response. Use
this value to get more backups.}

\item{MaxResults}{The maximum number of backups to return in the response. When there are
more backups than the number you specify, the response contains a
\code{NextToken} value.}

\item{Filters}{One or more filters to limit the items returned in the response.

Use the \code{backupIds} filter to return only the specified backups. Specify
backups by their backup identifier (ID).

Use the \code{sourceBackupIds} filter to return only the backups created from
a source backup. The \code{sourceBackupID} of a source backup is returned by
the \code{\link[=cloudhsmv2_copy_backup_to_region]{copy_backup_to_region}}
operation.

Use the \code{clusterIds} filter to return only the backups for the specified
clusters. Specify clusters by their cluster identifier (ID).

Use the \code{states} filter to return only backups that match the specified
state.

Use the \code{neverExpires} filter to return backups filtered by the value in
the \code{neverExpires} parameter. \code{True} returns all backups exempt from the
backup retention policy. \code{False} returns all backups with a backup
retention policy defined at the cluster.}

\item{SortAscending}{Designates whether or not to sort the return backups by ascending
chronological order of generation.}
}
\value{
A list with the following syntax:\preformatted{list(
  Backups = list(
    list(
      BackupId = "string",
      BackupState = "CREATE_IN_PROGRESS"|"READY"|"DELETED"|"PENDING_DELETION",
      ClusterId = "string",
      CreateTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      CopyTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      NeverExpires = TRUE|FALSE,
      SourceRegion = "string",
      SourceBackup = "string",
      SourceCluster = "string",
      DeleteTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      TagList = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets information about backups of AWS CloudHSM clusters.

This is a paginated operation, which means that each response might
contain only a subset of all the backups. When the response contains
only a subset of backups, it includes a \code{NextToken} value. Use this
value in a subsequent \code{\link[=cloudhsmv2_describe_backups]{describe_backups}}
request to get more backups. When you receive a response with no
\code{NextToken} (or an empty or null value), that means there are no more
backups to get.
}
\section{Request syntax}{
\preformatted{svc$describe_backups(
  NextToken = "string",
  MaxResults = 123,
  Filters = list(
    list(
      "string"
    )
  ),
  SortAscending = TRUE|FALSE
)
}
}

\keyword{internal}
