% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_reset_user_password}
\alias{cognitoidentityprovider_admin_reset_user_password}
\title{Resets the specified user's password in a user pool as an administrator}
\usage{
cognitoidentityprovider_admin_reset_user_password(UserPoolId, Username,
  ClientMetadata)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to reset the user's
password.}

\item{Username}{[required] The user name of the user whose password you wish to reset.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning AWS Lambda functions to user
pool triggers. When you use the AdminResetUserPassword API action,
Amazon Cognito invokes the function that is assigned to the \emph{custom
message} trigger. When Amazon Cognito invokes this function, it passes a
JSON payload, which the function receives as input. This payload
contains a \code{clientMetadata} attribute, which provides the data that you
assigned to the ClientMetadata parameter in your AdminResetUserPassword
request. In your function code in AWS Lambda, you can process the
\code{clientMetadata} value to enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don't use it to provide sensitive information.
}}
}
\value{
An empty list.
}
\description{
Resets the specified user's password in a user pool as an administrator.
Works on any user.

When a developer calls this API, the current password is invalidated, so
it must be changed. If a user tries to sign in after the API is called,
the app will get a PasswordResetRequiredException exception back and
should direct the user down the flow to reset the password, which is the
same as the forgot password flow. In addition, if the user pool has
phone verification selected and a verified phone number exists for the
user, or if email verification is selected and a verified email exists
for the user, calling this API will also result in sending a message to
the end user with the code to change their password.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_reset_user_password(
  UserPoolId = "string",
  Username = "string",
  ClientMetadata = list(
    "string"
  )
)
}
}

\keyword{internal}
