% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_user_pool}
\alias{cognitoidentityprovider_create_user_pool}
\title{Creates a new Amazon Cognito user pool and sets the password policy for
the pool}
\usage{
cognitoidentityprovider_create_user_pool(PoolName, Policies,
  LambdaConfig, AutoVerifiedAttributes, AliasAttributes,
  UsernameAttributes, SmsVerificationMessage, EmailVerificationMessage,
  EmailVerificationSubject, VerificationMessageTemplate,
  SmsAuthenticationMessage, MfaConfiguration, DeviceConfiguration,
  EmailConfiguration, SmsConfiguration, UserPoolTags,
  AdminCreateUserConfig, Schema, UserPoolAddOns, UsernameConfiguration,
  AccountRecoverySetting)
}
\arguments{
\item{PoolName}{[required] A string used to name the user pool.}

\item{Policies}{The policies associated with the new user pool.}

\item{LambdaConfig}{The Lambda trigger configuration information for the new user pool.

In a push model, event sources (such as Amazon S3 and custom
applications) need permission to invoke a function. So you will need to
make an extra call to add permission for these event sources to invoke
your Lambda function.

For more information on using the Lambda API to add permission, see
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html}{AddPermission}
.

For adding permission using the AWS CLI, see
\href{https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html}{add-permission}
.}

\item{AutoVerifiedAttributes}{The attributes to be auto-verified. Possible values: \strong{email},
\strong{phone_number}.}

\item{AliasAttributes}{Attributes supported as an alias for this user pool. Possible values:
\strong{phone_number}, \strong{email}, or \strong{preferred_username}.}

\item{UsernameAttributes}{Specifies whether email addresses or phone numbers can be specified as
usernames when a user signs up.}

\item{SmsVerificationMessage}{A string representing the SMS verification message.}

\item{EmailVerificationMessage}{A string representing the email verification message.
EmailVerificationMessage is allowed only if
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount}{EmailSendingAccount}
is DEVELOPER.}

\item{EmailVerificationSubject}{A string representing the email verification subject.
EmailVerificationSubject is allowed only if
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount}{EmailSendingAccount}
is DEVELOPER.}

\item{VerificationMessageTemplate}{The template for the verification message that the user sees when the
app requests permission to access the user's information.}

\item{SmsAuthenticationMessage}{A string representing the SMS authentication message.}

\item{MfaConfiguration}{Specifies MFA configuration details.}

\item{DeviceConfiguration}{The device configuration.}

\item{EmailConfiguration}{The email configuration.}

\item{SmsConfiguration}{The SMS configuration.}

\item{UserPoolTags}{The tag keys and values to assign to the user pool. A tag is a label
that you can use to categorize and manage user pools in different ways,
such as by purpose, owner, environment, or other criteria.}

\item{AdminCreateUserConfig}{The configuration for
\code{\link[=cognitoidentityprovider_admin_create_user]{admin_create_user}}
requests.}

\item{Schema}{An array of schema attributes for the new user pool. These attributes
can be standard or custom attributes.}

\item{UserPoolAddOns}{Used to enable advanced security risk detection. Set the key
\code{AdvancedSecurityMode} to the value "AUDIT".}

\item{UsernameConfiguration}{You can choose to set case sensitivity on the username input for the
selected sign-in option. For example, when this is set to \code{False}, users
will be able to sign in using either "username" or "Username". This
configuration is immutable once it has been set. For more information,
see
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html}{UsernameConfigurationType}.}

\item{AccountRecoverySetting}{Use this setting to define which verified available method a user can
use to recover their password when they call
\code{\link[=cognitoidentityprovider_forgot_password]{forgot_password}}. It allows
you to define a preferred method when a user has more than one method
available. With this setting, SMS does not qualify for a valid password
recovery mechanism if the user also has SMS MFA enabled. In the absence
of this setting, Cognito uses the legacy behavior to determine the
recovery method where SMS is preferred over email.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserPool = list(
    Id = "string",
    Name = "string",
    Policies = list(
      PasswordPolicy = list(
        MinimumLength = 123,
        RequireUppercase = TRUE|FALSE,
        RequireLowercase = TRUE|FALSE,
        RequireNumbers = TRUE|FALSE,
        RequireSymbols = TRUE|FALSE,
        TemporaryPasswordValidityDays = 123
      )
    ),
    LambdaConfig = list(
      PreSignUp = "string",
      CustomMessage = "string",
      PostConfirmation = "string",
      PreAuthentication = "string",
      PostAuthentication = "string",
      DefineAuthChallenge = "string",
      CreateAuthChallenge = "string",
      VerifyAuthChallengeResponse = "string",
      PreTokenGeneration = "string",
      UserMigration = "string",
      CustomSMSSender = list(
        LambdaVersion = "V1_0",
        LambdaArn = "string"
      ),
      CustomEmailSender = list(
        LambdaVersion = "V1_0",
        LambdaArn = "string"
      ),
      KMSKeyID = "string"
    ),
    Status = "Enabled"|"Disabled",
    LastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    CreationDate = as.POSIXct(
      "2015-01-01"
    ),
    SchemaAttributes = list(
      list(
        Name = "string",
        AttributeDataType = "String"|"Number"|"DateTime"|"Boolean",
        DeveloperOnlyAttribute = TRUE|FALSE,
        Mutable = TRUE|FALSE,
        Required = TRUE|FALSE,
        NumberAttributeConstraints = list(
          MinValue = "string",
          MaxValue = "string"
        ),
        StringAttributeConstraints = list(
          MinLength = "string",
          MaxLength = "string"
        )
      )
    ),
    AutoVerifiedAttributes = list(
      "phone_number"|"email"
    ),
    AliasAttributes = list(
      "phone_number"|"email"|"preferred_username"
    ),
    UsernameAttributes = list(
      "phone_number"|"email"
    ),
    SmsVerificationMessage = "string",
    EmailVerificationMessage = "string",
    EmailVerificationSubject = "string",
    VerificationMessageTemplate = list(
      SmsMessage = "string",
      EmailMessage = "string",
      EmailSubject = "string",
      EmailMessageByLink = "string",
      EmailSubjectByLink = "string",
      DefaultEmailOption = "CONFIRM_WITH_LINK"|"CONFIRM_WITH_CODE"
    ),
    SmsAuthenticationMessage = "string",
    MfaConfiguration = "OFF"|"ON"|"OPTIONAL",
    DeviceConfiguration = list(
      ChallengeRequiredOnNewDevice = TRUE|FALSE,
      DeviceOnlyRememberedOnUserPrompt = TRUE|FALSE
    ),
    EstimatedNumberOfUsers = 123,
    EmailConfiguration = list(
      SourceArn = "string",
      ReplyToEmailAddress = "string",
      EmailSendingAccount = "COGNITO_DEFAULT"|"DEVELOPER",
      From = "string",
      ConfigurationSet = "string"
    ),
    SmsConfiguration = list(
      SnsCallerArn = "string",
      ExternalId = "string"
    ),
    UserPoolTags = list(
      "string"
    ),
    SmsConfigurationFailure = "string",
    EmailConfigurationFailure = "string",
    Domain = "string",
    CustomDomain = "string",
    AdminCreateUserConfig = list(
      AllowAdminCreateUserOnly = TRUE|FALSE,
      UnusedAccountValidityDays = 123,
      InviteMessageTemplate = list(
        SMSMessage = "string",
        EmailMessage = "string",
        EmailSubject = "string"
      )
    ),
    UserPoolAddOns = list(
      AdvancedSecurityMode = "OFF"|"AUDIT"|"ENFORCED"
    ),
    UsernameConfiguration = list(
      CaseSensitive = TRUE|FALSE
    ),
    Arn = "string",
    AccountRecoverySetting = list(
      RecoveryMechanisms = list(
        list(
          Priority = 123,
          Name = "verified_email"|"verified_phone_number"|"admin_only"
        )
      )
    )
  )
)
}
}
\description{
Creates a new Amazon Cognito user pool and sets the password policy for
the pool.
}
\section{Request syntax}{
\preformatted{svc$create_user_pool(
  PoolName = "string",
  Policies = list(
    PasswordPolicy = list(
      MinimumLength = 123,
      RequireUppercase = TRUE|FALSE,
      RequireLowercase = TRUE|FALSE,
      RequireNumbers = TRUE|FALSE,
      RequireSymbols = TRUE|FALSE,
      TemporaryPasswordValidityDays = 123
    )
  ),
  LambdaConfig = list(
    PreSignUp = "string",
    CustomMessage = "string",
    PostConfirmation = "string",
    PreAuthentication = "string",
    PostAuthentication = "string",
    DefineAuthChallenge = "string",
    CreateAuthChallenge = "string",
    VerifyAuthChallengeResponse = "string",
    PreTokenGeneration = "string",
    UserMigration = "string",
    CustomSMSSender = list(
      LambdaVersion = "V1_0",
      LambdaArn = "string"
    ),
    CustomEmailSender = list(
      LambdaVersion = "V1_0",
      LambdaArn = "string"
    ),
    KMSKeyID = "string"
  ),
  AutoVerifiedAttributes = list(
    "phone_number"|"email"
  ),
  AliasAttributes = list(
    "phone_number"|"email"|"preferred_username"
  ),
  UsernameAttributes = list(
    "phone_number"|"email"
  ),
  SmsVerificationMessage = "string",
  EmailVerificationMessage = "string",
  EmailVerificationSubject = "string",
  VerificationMessageTemplate = list(
    SmsMessage = "string",
    EmailMessage = "string",
    EmailSubject = "string",
    EmailMessageByLink = "string",
    EmailSubjectByLink = "string",
    DefaultEmailOption = "CONFIRM_WITH_LINK"|"CONFIRM_WITH_CODE"
  ),
  SmsAuthenticationMessage = "string",
  MfaConfiguration = "OFF"|"ON"|"OPTIONAL",
  DeviceConfiguration = list(
    ChallengeRequiredOnNewDevice = TRUE|FALSE,
    DeviceOnlyRememberedOnUserPrompt = TRUE|FALSE
  ),
  EmailConfiguration = list(
    SourceArn = "string",
    ReplyToEmailAddress = "string",
    EmailSendingAccount = "COGNITO_DEFAULT"|"DEVELOPER",
    From = "string",
    ConfigurationSet = "string"
  ),
  SmsConfiguration = list(
    SnsCallerArn = "string",
    ExternalId = "string"
  ),
  UserPoolTags = list(
    "string"
  ),
  AdminCreateUserConfig = list(
    AllowAdminCreateUserOnly = TRUE|FALSE,
    UnusedAccountValidityDays = 123,
    InviteMessageTemplate = list(
      SMSMessage = "string",
      EmailMessage = "string",
      EmailSubject = "string"
    )
  ),
  Schema = list(
    list(
      Name = "string",
      AttributeDataType = "String"|"Number"|"DateTime"|"Boolean",
      DeveloperOnlyAttribute = TRUE|FALSE,
      Mutable = TRUE|FALSE,
      Required = TRUE|FALSE,
      NumberAttributeConstraints = list(
        MinValue = "string",
        MaxValue = "string"
      ),
      StringAttributeConstraints = list(
        MinLength = "string",
        MaxLength = "string"
      )
    )
  ),
  UserPoolAddOns = list(
    AdvancedSecurityMode = "OFF"|"AUDIT"|"ENFORCED"
  ),
  UsernameConfiguration = list(
    CaseSensitive = TRUE|FALSE
  ),
  AccountRecoverySetting = list(
    RecoveryMechanisms = list(
      list(
        Priority = 123,
        Name = "verified_email"|"verified_phone_number"|"admin_only"
      )
    )
  )
)
}
}

\keyword{internal}
