% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_domain_controllers}
\alias{directoryservice_describe_domain_controllers}
\title{Provides information about any domain controllers in your directory}
\usage{
directoryservice_describe_domain_controllers(DirectoryId,
  DomainControllerIds, NextToken, Limit)
}
\arguments{
\item{DirectoryId}{[required] Identifier of the directory for which to retrieve the domain controller
information.}

\item{DomainControllerIds}{A list of identifiers for the domain controllers whose information will
be provided.}

\item{NextToken}{The \emph{DescribeDomainControllers.NextToken} value from a previous call to
\code{\link[=directoryservice_describe_domain_controllers]{describe_domain_controllers}}.
Pass null if this is the first call.}

\item{Limit}{The maximum number of items to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  DomainControllers = list(
    list(
      DirectoryId = "string",
      DomainControllerId = "string",
      DnsIpAddr = "string",
      VpcId = "string",
      SubnetId = "string",
      AvailabilityZone = "string",
      Status = "Creating"|"Active"|"Impaired"|"Restoring"|"Deleting"|"Deleted"|"Failed",
      StatusReason = "string",
      LaunchTime = as.POSIXct(
        "2015-01-01"
      ),
      StatusLastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Provides information about any domain controllers in your directory.
}
\section{Request syntax}{
\preformatted{svc$describe_domain_controllers(
  DirectoryId = "string",
  DomainControllerIds = list(
    "string"
  ),
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
