% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_attach_role_policy}
\alias{iam_attach_role_policy}
\title{Attaches the specified managed policy to the specified IAM role}
\usage{
iam_attach_role_policy(RoleName, PolicyArn)
}
\arguments{
\item{RoleName}{[required] The name (friendly name, not ARN) of the role to attach the policy to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to attach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\value{
An empty list.
}
\description{
Attaches the specified managed policy to the specified IAM role. When
you attach a managed policy to a role, the managed policy becomes part
of the role's permission (access) policy.

You cannot use a managed policy as the role's trust policy. The role's
trust policy is created at the same time as the role, using
\code{\link[=iam_create_role]{create_role}}. You can update a role's trust policy
using \code{\link[=iam_update_assume_role_policy]{update_assume_role_policy}}.

Use this API to attach a \emph{managed} policy to a role. To embed an inline
policy in a role, use \code{\link[=iam_put_role_policy]{put_role_policy}}. For more
information about policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_role_policy(
  RoleName = "string",
  PolicyArn = "string"
)
}
}

\examples{
\dontrun{
# The following command attaches the AWS managed policy named
# ReadOnlyAccess to the IAM role named ReadOnlyRole.
svc$attach_role_policy(
  PolicyArn = "arn:aws:iam::aws:policy/ReadOnlyAccess",
  RoleName = "ReadOnlyRole"
)
}

}
\keyword{internal}
