% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_preview_agents}
\alias{inspector_preview_agents}
\title{Previews the agents installed on the EC2 instances that are part of the
specified assessment target}
\usage{
inspector_preview_agents(previewAgentsArn, nextToken, maxResults)
}
\arguments{
\item{previewAgentsArn}{[required] The ARN of the assessment target whose agents you want to preview.}

\item{nextToken}{You can use this parameter when paginating results. Set the value of
this parameter to null on your first call to the \strong{PreviewAgents}
action. Subsequent calls to the action fill \strong{nextToken} in the request
with the value of \strong{NextToken} from the previous response to continue
listing data.}

\item{maxResults}{You can use this parameter to indicate the maximum number of items you
want in the response. The default value is 10. The maximum value is 500.}
}
\value{
A list with the following syntax:\preformatted{list(
  agentPreviews = list(
    list(
      hostname = "string",
      agentId = "string",
      autoScalingGroup = "string",
      agentHealth = "HEALTHY"|"UNHEALTHY"|"UNKNOWN",
      agentVersion = "string",
      operatingSystem = "string",
      kernelVersion = "string",
      ipv4Address = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Previews the agents installed on the EC2 instances that are part of the
specified assessment target.
}
\section{Request syntax}{
\preformatted{svc$preview_agents(
  previewAgentsArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
\dontrun{
# Previews the agents installed on the EC2 instances that are part of the
# specified assessment target.
svc$preview_agents(
  maxResults = 123L,
  previewAgentsArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
)
}

}
\keyword{internal}
