% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_associate_resource_share}
\alias{ram_associate_resource_share}
\title{Associates the specified resource share with the specified principals
and resources}
\usage{
ram_associate_resource_share(resourceShareArn, resourceArns, principals,
  clientToken)
}
\arguments{
\item{resourceShareArn}{[required] The Amazon Resource Name (ARN) of the resource share.}

\item{resourceArns}{The Amazon Resource Names (ARN) of the resources.}

\item{principals}{The principals.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  resourceShareAssociations = list(
    list(
      resourceShareArn = "string",
      resourceShareName = "string",
      associatedEntity = "string",
      associationType = "PRINCIPAL"|"RESOURCE",
      status = "ASSOCIATING"|"ASSOCIATED"|"FAILED"|"DISASSOCIATING"|"DISASSOCIATED",
      statusMessage = "string",
      creationTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedTime = as.POSIXct(
        "2015-01-01"
      ),
      external = TRUE|FALSE
    )
  ),
  clientToken = "string"
)
}
}
\description{
Associates the specified resource share with the specified principals
and resources.
}
\section{Request syntax}{
\preformatted{svc$associate_resource_share(
  resourceShareArn = "string",
  resourceArns = list(
    "string"
  ),
  principals = list(
    "string"
  ),
  clientToken = "string"
)
}
}

\keyword{internal}
