% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_associate_proactive_engagement_details}
\alias{shield_associate_proactive_engagement_details}
\title{Initializes proactive engagement and sets the list of contacts for the
DDoS Response Team (DRT) to use}
\usage{
shield_associate_proactive_engagement_details(EmergencyContactList)
}
\arguments{
\item{EmergencyContactList}{[required] A list of email addresses and phone numbers that the DDoS Response Team
(DRT) can use to contact you for escalations to the DRT and to initiate
proactive customer support.

To enable proactive engagement, the contact list must include at least
one phone number.

The contacts that you provide here replace any contacts that were
already defined. If you already have contacts defined and want to use
them, retrieve the list using
\code{\link[=shield_describe_emergency_contact_settings]{describe_emergency_contact_settings}}
and then provide it here.}
}
\value{
An empty list.
}
\description{
Initializes proactive engagement and sets the list of contacts for the
DDoS Response Team (DRT) to use. You must provide at least one phone
number in the emergency contact list.

After you have initialized proactive engagement using this call, to
disable or enable proactive engagement, use the calls
\code{\link[=shield_disable_proactive_engagement]{disable_proactive_engagement}}
and \code{\link[=shield_enable_proactive_engagement]{enable_proactive_engagement}}.

This call defines the list of email addresses and phone numbers that the
DDoS Response Team (DRT) can use to contact you for escalations to the
DRT and to initiate proactive customer support.

The contacts that you provide in the request replace any contacts that
were already defined. If you already have contacts defined and want to
use them, retrieve the list using
\code{\link[=shield_describe_emergency_contact_settings]{describe_emergency_contact_settings}}
and then provide it to this call.
}
\section{Request syntax}{
\preformatted{svc$associate_proactive_engagement_details(
  EmergencyContactList = list(
    list(
      EmailAddress = "string",
      PhoneNumber = "string",
      ContactNotes = "string"
    )
  )
)
}
}

\keyword{internal}
