% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_delete_assessment_run}
\alias{inspector_delete_assessment_run}
\title{Deletes the assessment run that is specified by the ARN of the
assessment run}
\usage{
inspector_delete_assessment_run(assessmentRunArn)
}
\arguments{
\item{assessmentRunArn}{[required] The ARN that specifies the assessment run that you want to delete.}
}
\description{
Deletes the assessment run that is specified by the ARN of the
assessment run.
}
\section{Request syntax}{
\preformatted{svc$delete_assessment_run(
  assessmentRunArn = "string"
)
}
}

\examples{
# Deletes the assessment run that is specified by the ARN of the
# assessment run.
\donttest{svc$delete_assessment_run(
  assessmentRunArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-..."
)}

}
\keyword{internal}
