% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_confirm_sign_up}
\alias{cognitoidentityprovider_confirm_sign_up}
\title{Confirms registration of a user and handles the existing alias from a
previous user}
\usage{
cognitoidentityprovider_confirm_sign_up(ClientId, SecretHash, Username,
  ConfirmationCode, ForceAliasCreation, AnalyticsMetadata,
  UserContextData)
}
\arguments{
\item{ClientId}{[required] The ID of the app client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The user name of the user whose registration you wish to confirm.}

\item{ConfirmationCode}{[required] The confirmation code sent by a user's request to confirm registration.}

\item{ForceAliasCreation}{Boolean to be specified to force user confirmation irrespective of
existing alias. By default set to \code{False}. If this parameter is set to
\code{True} and the phone number/email used for sign up confirmation already
exists as an alias with a different user, the API call will migrate the
alias from the previous user to the newly created user being confirmed.
If set to \code{False}, the API will throw an \strong{AliasExistsException} error.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{ConfirmSignUp} calls.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Confirms registration of a user and handles the existing alias from a
previous user.
}
\section{Request syntax}{
\preformatted{svc$confirm_sign_up(
  ClientId = "string",
  SecretHash = "string",
  Username = "string",
  ConfirmationCode = "string",
  ForceAliasCreation = TRUE|FALSE,
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
