% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_user}
\alias{iam_update_user}
\title{Updates the name and/or the path of the specified IAM user}
\usage{
iam_update_user(UserName, NewPath, NewUserName)
}
\arguments{
\item{UserName}{[required] Name of the user to update. If you\'re changing the name of the user,
this is the original user name.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{NewPath}{New path for the IAM user. Include this parameter only if you\'re
changing the user\'s path.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{NewUserName}{New name for the user. Include this parameter only if you\'re changing
the user\'s name.

IAM user, group, role, and policy names must be unique within the
account. Names are not distinguished by case. For example, you cannot
create resources named both \"MyResource\" and \"myresource\".}
}
\description{
Updates the name and/or the path of the specified IAM user.
}
\details{
You should understand the implications of changing an IAM user\'s path
or name. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming}{Renaming an IAM User}
and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html}{Renaming an IAM Group}
in the \emph{IAM User Guide}.

To change a user name, the requester must have appropriate permissions
on both the source object and the target object. For example, to change
Bob to Robert, the entity making the request must have permission on Bob
and Robert, or must have permission on all (*). For more information
about permissions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html}{Permissions and Policies}.
}
\section{Request syntax}{
\preformatted{svc$update_user(
  UserName = "string",
  NewPath = "string",
  NewUserName = "string"
)
}
}

\examples{
# The following command changes the name of the IAM user Bob to Robert. It
# does not change the user's path.
\donttest{svc$update_user(
  NewUserName = "Robert",
  UserName = "Bob"
)}

}
\keyword{internal}
